/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.flexible.standard.builders;

import guideme.internal.shaded.lucene.queryparser.flexible.core.QueryNodeException;
import guideme.internal.shaded.lucene.queryparser.flexible.core.nodes.FieldQueryNode;
import guideme.internal.shaded.lucene.queryparser.flexible.core.nodes.QueryNode;
import guideme.internal.shaded.lucene.queryparser.flexible.core.util.StringUtils;
import guideme.internal.shaded.lucene.queryparser.flexible.standard.builders.StandardQueryBuilder;
import guideme.internal.shaded.lucene.queryparser.flexible.standard.nodes.TermRangeQueryNode;
import guideme.internal.shaded.lucene.search.MultiTermQuery;
import guideme.internal.shaded.lucene.search.TermRangeQuery;

public class TermRangeQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public TermRangeQuery build(QueryNode queryNode) throws QueryNodeException {
        MultiTermQuery.RewriteMethod method;
        TermRangeQueryNode rangeNode = (TermRangeQueryNode)queryNode;
        FieldQueryNode upper = (FieldQueryNode)rangeNode.getUpperBound();
        FieldQueryNode lower = (FieldQueryNode)rangeNode.getLowerBound();
        String field = StringUtils.toString(rangeNode.getField());
        String lowerText = lower.getTextAsString();
        String upperText = upper.getTextAsString();
        if (lowerText.length() == 0) {
            lowerText = null;
        }
        if (upperText.length() == 0) {
            upperText = null;
        }
        if ((method = (MultiTermQuery.RewriteMethod)queryNode.getTag("MultiTermRewriteMethodConfiguration")) == null) {
            method = MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE;
        }
        return TermRangeQuery.newStringRange(field, lowerText, upperText, rangeNode.isLowerInclusive(), rangeNode.isUpperInclusive(), method);
    }
}

