/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.function.valuesource;

import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.VectorEncoding;
import guideme.internal.shaded.lucene.queries.function.FunctionValues;
import guideme.internal.shaded.lucene.queries.function.ValueSource;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import java.io.IOException;

public abstract class VectorFieldFunction
extends FunctionValues {
    protected final ValueSource valueSource;
    int lastDocID;

    protected VectorFieldFunction(ValueSource valueSource) {
        this.valueSource = valueSource;
    }

    protected abstract DocIdSetIterator getVectorIterator();

    @Override
    public String toString(int doc) throws IOException {
        return this.valueSource.description() + this.strVal(doc);
    }

    @Override
    public boolean exists(int doc) throws IOException {
        if (doc < this.lastDocID) {
            throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
        }
        this.lastDocID = doc;
        int curDocID = this.getVectorIterator().docID();
        if (doc > curDocID) {
            curDocID = this.getVectorIterator().advance(doc);
        }
        return doc == curDocID;
    }

    static void checkField(LeafReader in, String field, VectorEncoding expectedEncoding) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field);
        if (fi != null) {
            VectorEncoding actual;
            VectorEncoding vectorEncoding = actual = fi.hasVectorValues() ? fi.getVectorEncoding() : null;
            if (expectedEncoding != actual) {
                throw new IllegalStateException("Unexpected vector encoding (" + String.valueOf((Object)actual) + ") for field " + field + "(expected=" + String.valueOf((Object)expectedEncoding) + ")");
            }
        }
    }
}

