/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.function.valuesource;

import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.queries.function.valuesource.LongFieldSource;
import guideme.internal.shaded.lucene.search.SortField;
import guideme.internal.shaded.lucene.search.SortedNumericSelector;
import guideme.internal.shaded.lucene.search.SortedNumericSortField;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class MultiValuedLongFieldSource
extends LongFieldSource {
    protected final SortedNumericSelector.Type selector;

    public MultiValuedLongFieldSource(String field, SortedNumericSelector.Type selector) {
        super(field);
        this.selector = selector;
        Objects.requireNonNull(field, "Field is required to create a MultiValuedLongFieldSource");
        Objects.requireNonNull(selector, "SortedNumericSelector is required to create a MultiValuedLongFieldSource");
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortedNumericSortField(this.field, SortField.Type.LONG, reverse, this.selector);
    }

    @Override
    public String description() {
        return "long(" + this.field + "," + this.selector.name() + ")";
    }

    @Override
    protected NumericDocValues getNumericDocValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        SortedNumericDocValues sortedDv = DocValues.getSortedNumeric(readerContext.reader(), this.field);
        return SortedNumericSelector.wrap(sortedDv, this.selector, SortField.Type.LONG);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != MultiValuedLongFieldSource.class) {
            return false;
        }
        MultiValuedLongFieldSource other = (MultiValuedLongFieldSource)o;
        if (this.selector != other.selector) {
            return false;
        }
        return this.field.equals(other.field);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        return h += this.selector.hashCode();
    }
}

