/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.Codec;
import guideme.internal.shaded.lucene.codecs.CompoundDirectory;
import guideme.internal.shaded.lucene.codecs.FieldsProducer;
import guideme.internal.shaded.lucene.codecs.KnnVectorsReader;
import guideme.internal.shaded.lucene.codecs.NormsProducer;
import guideme.internal.shaded.lucene.codecs.PointsReader;
import guideme.internal.shaded.lucene.codecs.PostingsFormat;
import guideme.internal.shaded.lucene.codecs.StoredFieldsReader;
import guideme.internal.shaded.lucene.codecs.TermVectorsReader;
import guideme.internal.shaded.lucene.index.CorruptIndexException;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.SegmentCommitInfo;
import guideme.internal.shaded.lucene.index.SegmentReadState;
import guideme.internal.shaded.lucene.store.AlreadyClosedException;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.util.IOUtils;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

final class SegmentCoreReaders {
    private final AtomicInteger ref = new AtomicInteger(1);
    final FieldsProducer fields;
    final NormsProducer normsProducer;
    final StoredFieldsReader fieldsReaderOrig;
    final TermVectorsReader termVectorsReaderOrig;
    final PointsReader pointsReader;
    final KnnVectorsReader knnVectorsReader;
    final CompoundDirectory cfsReader;
    final String segment;
    final FieldInfos coreFieldInfos;
    private final Set<IndexReader.ClosedListener> coreClosedListeners = Collections.synchronizedSet(new LinkedHashSet());
    private final IndexReader.CacheHelper cacheHelper = new IndexReader.CacheHelper(){
        private final IndexReader.CacheKey cacheKey = new IndexReader.CacheKey();

        @Override
        public IndexReader.CacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public void addClosedListener(IndexReader.ClosedListener listener) {
            SegmentCoreReaders.this.coreClosedListeners.add(listener);
        }
    };

    SegmentCoreReaders(Directory dir, SegmentCommitInfo si, IOContext context) throws IOException {
        Codec codec = si.info.getCodec();
        boolean success = false;
        try {
            Directory cfsDir;
            if (si.info.getUseCompoundFile()) {
                this.cfsReader = codec.compoundFormat().getCompoundReader(dir, si.info);
                cfsDir = this.cfsReader;
            } else {
                this.cfsReader = null;
                cfsDir = dir;
            }
            this.segment = si.info.name;
            this.coreFieldInfos = codec.fieldInfosFormat().read(cfsDir, si.info, "", context);
            SegmentReadState segmentReadState = new SegmentReadState(cfsDir, si.info, this.coreFieldInfos, context);
            if (this.coreFieldInfos.hasPostings()) {
                PostingsFormat format = codec.postingsFormat();
                this.fields = format.fieldsProducer(segmentReadState);
                assert (this.fields != null);
            } else {
                this.fields = null;
            }
            if (this.coreFieldInfos.hasNorms()) {
                this.normsProducer = codec.normsFormat().normsProducer(segmentReadState);
                assert (this.normsProducer != null);
            } else {
                this.normsProducer = null;
            }
            this.fieldsReaderOrig = si.info.getCodec().storedFieldsFormat().fieldsReader(cfsDir, si.info, this.coreFieldInfos, context);
            this.termVectorsReaderOrig = this.coreFieldInfos.hasTermVectors() ? si.info.getCodec().termVectorsFormat().vectorsReader(cfsDir, si.info, this.coreFieldInfos, context) : null;
            this.pointsReader = this.coreFieldInfos.hasPointValues() ? codec.pointsFormat().fieldsReader(segmentReadState) : null;
            this.knnVectorsReader = this.coreFieldInfos.hasVectorValues() ? codec.knnVectorsFormat().fieldsReader(segmentReadState) : null;
            success = true;
        }
        catch (EOFException | FileNotFoundException e) {
            throw new CorruptIndexException("Problem reading index from " + String.valueOf(dir), dir.toString(), (Throwable)e);
        }
        catch (NoSuchFileException e) {
            throw new CorruptIndexException("Problem reading index.", e.getFile(), (Throwable)e);
        }
        finally {
            if (!success) {
                this.decRef();
            }
        }
    }

    int getRefCount() {
        return this.ref.get();
    }

    void incRef() {
        int count;
        while ((count = this.ref.get()) > 0) {
            if (!this.ref.compareAndSet(count, count + 1)) continue;
            return;
        }
        throw new AlreadyClosedException("SegmentCoreReaders is already closed");
    }

    void decRef() throws IOException {
        if (this.ref.decrementAndGet() == 0) {
            try (Closeable finalizer = this::notifyCoreClosedListeners;){
                IOUtils.close(this.fields, this.termVectorsReaderOrig, this.fieldsReaderOrig, this.cfsReader, this.normsProducer, this.pointsReader, this.knnVectorsReader);
            }
        }
    }

    IndexReader.CacheHelper getCacheHelper() {
        return this.cacheHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCoreClosedListeners() throws IOException {
        Set<IndexReader.ClosedListener> set = this.coreClosedListeners;
        synchronized (set) {
            IOUtils.applyToAll(this.coreClosedListeners, l -> l.onClose(this.cacheHelper.getKey()));
        }
    }

    public String toString() {
        return "SegmentCoreReader(" + this.segment + ")";
    }
}

