/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.BufferedUpdates;
import guideme.internal.shaded.lucene.index.DocValuesUpdate;
import guideme.internal.shaded.lucene.index.FrozenBufferedUpdates;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.store.AlreadyClosedException;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.InfoStream;
import java.io.Closeable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongSupplier;

final class DocumentsWriterDeleteQueue
implements Accountable,
Closeable {
    private volatile Node<?> tail;
    private volatile boolean closed = false;
    private final DeleteSlice globalSlice;
    private final BufferedUpdates globalBufferedUpdates;
    final ReentrantLock globalBufferLock = new ReentrantLock();
    final long generation;
    private final AtomicLong nextSeqNo;
    private final InfoStream infoStream;
    private volatile long maxSeqNo = Long.MAX_VALUE;
    private final long startSeqNo;
    private final LongSupplier previousMaxSeqId;
    private boolean advanced;

    DocumentsWriterDeleteQueue(InfoStream infoStream) {
        this(infoStream, 0L, 1L, () -> 0L);
    }

    private DocumentsWriterDeleteQueue(InfoStream infoStream, long generation, long startSeqNo, LongSupplier previousMaxSeqId) {
        this.infoStream = infoStream;
        this.globalBufferedUpdates = new BufferedUpdates("global");
        this.generation = generation;
        this.nextSeqNo = new AtomicLong(startSeqNo);
        this.startSeqNo = startSeqNo;
        this.previousMaxSeqId = previousMaxSeqId;
        long value = previousMaxSeqId.getAsLong();
        assert (value <= startSeqNo) : "illegal max sequence ID: " + value + " start was: " + startSeqNo;
        this.tail = new Node<Object>(null);
        this.globalSlice = new DeleteSlice(this.tail);
    }

    long addDelete(Query ... queries) {
        long seqNo = this.add(new QueryArrayNode(queries));
        this.tryApplyGlobalSlice();
        return seqNo;
    }

    long addDelete(Term ... terms) {
        long seqNo = this.add(new TermArrayNode(terms));
        this.tryApplyGlobalSlice();
        return seqNo;
    }

    long addDocValuesUpdates(DocValuesUpdate ... updates) {
        long seqNo = this.add(new DocValuesUpdatesNode(updates));
        this.tryApplyGlobalSlice();
        return seqNo;
    }

    static Node<Term> newNode(Term term) {
        return new TermNode(term);
    }

    static Node<Query> newNode(Query query) {
        return new QueryNode(query);
    }

    static Node<DocValuesUpdate[]> newNode(DocValuesUpdate ... updates) {
        return new DocValuesUpdatesNode(updates);
    }

    long add(Node<?> deleteNode, DeleteSlice slice) {
        long seqNo = this.add(deleteNode);
        slice.sliceTail = deleteNode;
        assert (slice.sliceHead != slice.sliceTail) : "slice head and tail must differ after add";
        this.tryApplyGlobalSlice();
        return seqNo;
    }

    synchronized long add(Node<?> newNode) {
        this.ensureOpen();
        this.tail.next = newNode;
        this.tail = newNode;
        return this.getNextSequenceNumber();
    }

    boolean anyChanges() {
        this.globalBufferLock.lock();
        try {
            boolean bl = this.globalBufferedUpdates.any() || !this.globalSlice.isEmpty() || this.globalSlice.sliceTail != this.tail || this.tail.next != null;
            return bl;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    void tryApplyGlobalSlice() {
        if (this.globalBufferLock.tryLock()) {
            this.ensureOpen();
            try {
                if (this.updateSliceNoSeqNo(this.globalSlice)) {
                    this.globalSlice.apply(this.globalBufferedUpdates, BufferedUpdates.MAX_INT);
                }
            }
            finally {
                this.globalBufferLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FrozenBufferedUpdates freezeGlobalBuffer(DeleteSlice callerSlice) {
        this.globalBufferLock.lock();
        try {
            this.ensureOpen();
            Node<?> currentTail = this.tail;
            if (callerSlice != null) {
                callerSlice.sliceTail = currentTail;
            }
            FrozenBufferedUpdates frozenBufferedUpdates = this.freezeGlobalBufferInternal(currentTail);
            return frozenBufferedUpdates;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    FrozenBufferedUpdates maybeFreezeGlobalBuffer() {
        this.globalBufferLock.lock();
        try {
            if (!this.closed) {
                FrozenBufferedUpdates frozenBufferedUpdates = this.freezeGlobalBufferInternal(this.tail);
                return frozenBufferedUpdates;
            }
            assert (!this.anyChanges()) : "we are closed but have changes";
            FrozenBufferedUpdates frozenBufferedUpdates = null;
            return frozenBufferedUpdates;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    private FrozenBufferedUpdates freezeGlobalBufferInternal(Node<?> currentTail) {
        assert (this.globalBufferLock.isHeldByCurrentThread());
        if (this.globalSlice.sliceTail != currentTail) {
            this.globalSlice.sliceTail = currentTail;
            this.globalSlice.apply(this.globalBufferedUpdates, BufferedUpdates.MAX_INT);
        }
        if (this.globalBufferedUpdates.any()) {
            FrozenBufferedUpdates packet = new FrozenBufferedUpdates(this.infoStream, this.globalBufferedUpdates, null);
            this.globalBufferedUpdates.clear();
            return packet;
        }
        return null;
    }

    DeleteSlice newSlice() {
        return new DeleteSlice(this.tail);
    }

    synchronized long updateSlice(DeleteSlice slice) {
        this.ensureOpen();
        long seqNo = this.getNextSequenceNumber();
        if (slice.sliceTail != this.tail) {
            slice.sliceTail = this.tail;
            seqNo = -seqNo;
        }
        return seqNo;
    }

    boolean updateSliceNoSeqNo(DeleteSlice slice) {
        if (slice.sliceTail != this.tail) {
            slice.sliceTail = this.tail;
            return true;
        }
        return false;
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("This " + DocumentsWriterDeleteQueue.class.getSimpleName() + " is already closed");
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public synchronized void close() {
        this.globalBufferLock.lock();
        try {
            if (this.anyChanges()) {
                throw new IllegalStateException("Can't close queue unless all changes are applied");
            }
            this.closed = true;
            long seqNo = this.nextSeqNo.get();
            assert (seqNo <= this.maxSeqNo) : "maxSeqNo must be greater or equal to " + seqNo + " but was " + this.maxSeqNo;
            this.nextSeqNo.set(this.maxSeqNo + 1L);
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    int numGlobalTermDeletes() {
        return this.globalBufferedUpdates.deleteTerms.size();
    }

    void clear() {
        this.globalBufferLock.lock();
        try {
            Node<?> currentTail = this.tail;
            this.globalSlice.sliceTail = currentTail;
            this.globalSlice.sliceHead = this.globalSlice.sliceTail;
            this.globalBufferedUpdates.clear();
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBufferedUpdatesTermsSize() {
        ReentrantLock lock = this.globalBufferLock;
        lock.lock();
        try {
            Node<?> currentTail = this.tail;
            if (this.globalSlice.sliceTail != currentTail) {
                this.globalSlice.sliceTail = currentTail;
                this.globalSlice.apply(this.globalBufferedUpdates, BufferedUpdates.MAX_INT);
            }
            int n = this.globalBufferedUpdates.deleteTerms.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.globalBufferedUpdates.ramBytesUsed();
    }

    public String toString() {
        return "DWDQ: [ generation: " + this.generation + " ]";
    }

    public long getNextSequenceNumber() {
        long seqNo = this.nextSeqNo.getAndIncrement();
        assert (seqNo <= this.maxSeqNo) : "seqNo=" + seqNo + " vs maxSeqNo=" + this.maxSeqNo;
        return seqNo;
    }

    long getLastSequenceNumber() {
        return this.nextSeqNo.get() - 1L;
    }

    void skipSequenceNumbers(long jump) {
        this.nextSeqNo.addAndGet(jump);
    }

    long getMaxCompletedSeqNo() {
        if (this.startSeqNo < this.nextSeqNo.get()) {
            return this.getLastSequenceNumber();
        }
        long value = this.previousMaxSeqId.getAsLong();
        assert (value < this.startSeqNo) : "illegal max sequence ID: " + value + " start was: " + this.startSeqNo;
        return value;
    }

    private static LongSupplier getPrevMaxSeqIdSupplier(AtomicLong nextSeqNo) {
        return () -> nextSeqNo.get() - 1L;
    }

    synchronized DocumentsWriterDeleteQueue advanceQueue(int maxNumPendingOps) {
        long seqNo;
        if (this.advanced) {
            throw new IllegalStateException("queue was already advanced");
        }
        this.advanced = true;
        this.maxSeqNo = seqNo = this.getLastSequenceNumber() + (long)maxNumPendingOps + 1L;
        return new DocumentsWriterDeleteQueue(this.infoStream, this.generation + 1L, seqNo + 1L, DocumentsWriterDeleteQueue.getPrevMaxSeqIdSupplier(this.nextSeqNo));
    }

    long getMaxSeqNo() {
        return this.maxSeqNo;
    }

    synchronized boolean isAdvanced() {
        return this.advanced;
    }

    static class Node<T> {
        volatile Node<?> next;
        final T item;

        Node(T item) {
            this.item = item;
        }

        void apply(BufferedUpdates bufferedDeletes, int docIDUpto) {
            throw new IllegalStateException("sentinel item must never be applied");
        }

        boolean isDelete() {
            return true;
        }
    }

    static class DeleteSlice {
        Node<?> sliceHead;
        Node<?> sliceTail;

        DeleteSlice(Node<?> currentTail) {
            assert (currentTail != null);
            this.sliceTail = currentTail;
            this.sliceHead = this.sliceTail;
        }

        void apply(BufferedUpdates del, int docIDUpto) {
            if (this.sliceHead == this.sliceTail) {
                return;
            }
            Node<?> current = this.sliceHead;
            do {
                current = current.next;
                assert (current != null) : "slice property violated between the head on the tail must not be a null node";
                current.apply(del, docIDUpto);
            } while (current != this.sliceTail);
            this.reset();
        }

        void reset() {
            this.sliceHead = this.sliceTail;
        }

        boolean isTail(Node<?> node) {
            return this.sliceTail == node;
        }

        boolean isTailItem(Object object) {
            return this.sliceTail.item == object;
        }

        boolean isEmpty() {
            return this.sliceHead == this.sliceTail;
        }
    }

    private static final class QueryArrayNode
    extends Node<Query[]> {
        QueryArrayNode(Query[] query) {
            super(query);
        }

        @Override
        void apply(BufferedUpdates bufferedUpdates, int docIDUpto) {
            for (Query query : (Query[])this.item) {
                bufferedUpdates.addQuery(query, docIDUpto);
            }
        }
    }

    private static final class TermArrayNode
    extends Node<Term[]> {
        TermArrayNode(Term[] term) {
            super(term);
        }

        @Override
        void apply(BufferedUpdates bufferedUpdates, int docIDUpto) {
            for (Term term : (Term[])this.item) {
                bufferedUpdates.addTerm(term, docIDUpto);
            }
        }

        public String toString() {
            return "dels=" + Arrays.toString((Object[])this.item);
        }
    }

    private static final class DocValuesUpdatesNode
    extends Node<DocValuesUpdate[]> {
        DocValuesUpdatesNode(DocValuesUpdate ... updates) {
            super(updates);
        }

        @Override
        void apply(BufferedUpdates bufferedUpdates, int docIDUpto) {
            block4: for (DocValuesUpdate update : (DocValuesUpdate[])this.item) {
                switch (update.type) {
                    case NUMERIC: {
                        bufferedUpdates.addNumericUpdate((DocValuesUpdate.NumericDocValuesUpdate)update, docIDUpto);
                        continue block4;
                    }
                    case BINARY: {
                        bufferedUpdates.addBinaryUpdate((DocValuesUpdate.BinaryDocValuesUpdate)update, docIDUpto);
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException(String.valueOf((Object)update.type) + " DocValues updates not supported yet!");
                    }
                }
            }
        }

        @Override
        boolean isDelete() {
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("docValuesUpdates: ");
            if (((DocValuesUpdate[])this.item).length > 0) {
                sb.append("term=").append(((DocValuesUpdate[])this.item)[0].term).append("; updates: [");
                for (DocValuesUpdate update : (DocValuesUpdate[])this.item) {
                    sb.append(update.field).append(':').append(update.valueToString()).append(',');
                }
                sb.setCharAt(sb.length() - 1, ']');
            }
            return sb.toString();
        }
    }

    private static final class TermNode
    extends Node<Term> {
        TermNode(Term term) {
            super(term);
        }

        @Override
        void apply(BufferedUpdates bufferedDeletes, int docIDUpto) {
            bufferedDeletes.addTerm((Term)this.item, docIDUpto);
        }

        public String toString() {
            return "del=" + String.valueOf(this.item);
        }
    }

    private static final class QueryNode
    extends Node<Query> {
        QueryNode(Query query) {
            super(query);
        }

        @Override
        void apply(BufferedUpdates bufferedDeletes, int docIDUpto) {
            bufferedDeletes.addQuery((Query)this.item, docIDUpto);
        }

        public String toString() {
            return "del=" + String.valueOf(this.item);
        }
    }
}

