/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.ngram;

import guideme.internal.shaded.lucene.analysis.Tokenizer;
import guideme.internal.shaded.lucene.analysis.TokenizerFactory;
import guideme.internal.shaded.lucene.analysis.ngram.EdgeNGramTokenizer;
import guideme.internal.shaded.lucene.util.AttributeFactory;
import java.util.Map;

public class EdgeNGramTokenizerFactory
extends TokenizerFactory {
    public static final String NAME = "edgeNGram";
    private final int maxGramSize;
    private final int minGramSize;

    public EdgeNGramTokenizerFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.getInt(args, "minGramSize", 1);
        this.maxGramSize = this.getInt(args, "maxGramSize", 1);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public EdgeNGramTokenizerFactory() {
        throw EdgeNGramTokenizerFactory.defaultCtorException();
    }

    @Override
    public Tokenizer create(AttributeFactory factory) {
        return new EdgeNGramTokenizer(factory, this.minGramSize, this.maxGramSize);
    }
}

