/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.guiclock_common_neoforge.events;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.natamus.collective_common_neoforge.functions.GUIFunctions;
import com.natamus.collective_common_neoforge.functions.StringFunctions;
import com.natamus.guiclock_common_neoforge.config.ConfigHandler;
import java.awt.Color;
import java.util.Collection;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GUIEvent {
    private static final Minecraft mc = Minecraft.getInstance();
    private static String daystring = "";

    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Collection activeeffects;
        if (GUIFunctions.shouldHideGUI()) {
            return;
        }
        boolean gametimeb = ConfigHandler.mustHaveClockInInventoryForGameTime;
        boolean realtimeb = ConfigHandler.mustHaveClockInInventoryForRealTime;
        boolean found = true;
        if ((gametimeb || realtimeb) && !(found = GUIEvent.mc.player.getOffhandItem().getItem().equals(Items.CLOCK))) {
            Inventory inv = GUIEvent.mc.player.getInventory();
            for (int n = 0; n <= 35; ++n) {
                if (!inv.getItem(n).getItem().equals(Items.CLOCK)) continue;
                found = true;
                break;
            }
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        Font fontRenderer = GUIEvent.mc.font;
        Window scaled = mc.getWindow();
        int width = scaled.getGuiScaledWidth();
        int heightoffset = ConfigHandler.clockHeightOffset;
        if (heightoffset < 5) {
            heightoffset = 5;
        }
        if (ConfigHandler.lowerClockWhenPlayerHasEffects && (activeeffects = GUIEvent.mc.player.getActiveEffects()).size() > 0) {
            boolean haspositive = false;
            boolean hasnegative = false;
            for (MobEffectInstance effect : activeeffects) {
                if (!effect.isVisible()) continue;
                if (((MobEffect)effect.getEffect().value()).getCategory().equals((Object)MobEffectCategory.BENEFICIAL)) {
                    haspositive = true;
                } else {
                    hasnegative = true;
                }
                if (!haspositive || !hasnegative) continue;
                break;
            }
            if (hasnegative && haspositive) {
                heightoffset += 50;
            } else if (haspositive && !hasnegative) {
                heightoffset += 25;
            }
        }
        if (ConfigHandler.showOnlyMinecraftClockIcon) {
            if (gametimeb && !found) {
                return;
            }
            int xcoord = ConfigHandler.clockPositionIsLeft ? 20 : (ConfigHandler.clockPositionIsCenter ? width / 2 - 8 : width - 20);
            guiGraphics.renderItem(new ItemStack((ItemLike)Items.CLOCK), xcoord += ConfigHandler.clockWidthOffset, heightoffset);
        } else {
            int daycoord;
            Object time;
            String realtime = StringFunctions.getPCLocalTime((boolean)ConfigHandler._24hourformat, (boolean)ConfigHandler.showRealTimeSeconds);
            if (ConfigHandler.showBothTimes) {
                if (gametimeb && realtimeb) {
                    if (!found) {
                        return;
                    }
                    time = GUIEvent.getGameTime() + " | " + realtime;
                } else {
                    time = !found && gametimeb ? realtime : (!found && realtimeb ? GUIEvent.getGameTime() : GUIEvent.getGameTime() + " | " + realtime);
                }
            } else if (ConfigHandler.showRealTime) {
                if (realtimeb && !found) {
                    return;
                }
                time = realtime;
            } else {
                if (gametimeb && !found) {
                    return;
                }
                time = GUIEvent.getGameTime();
            }
            if (((String)time).equals("")) {
                return;
            }
            int stringWidth = fontRenderer.width((String)time);
            int daystringWidth = fontRenderer.width(daystring);
            Color colour = new Color(ConfigHandler.RGB_R, ConfigHandler.RGB_G, ConfigHandler.RGB_B, 255);
            if (ConfigHandler.clockPositionIsLeft) {
                xcoord = 5;
                daycoord = 5;
            } else if (ConfigHandler.clockPositionIsCenter) {
                xcoord = width / 2 - stringWidth / 2;
                daycoord = width / 2 - daystringWidth / 2;
            } else {
                xcoord = width - stringWidth - 5;
                daycoord = width - daystringWidth - 5;
            }
            daycoord += ConfigHandler.clockWidthOffset;
            int rgb = colour.getRGB();
            GUIEvent.drawText(fontRenderer, guiGraphics, (String)time, xcoord += ConfigHandler.clockWidthOffset, heightoffset, rgb, ConfigHandler.drawTextShadow);
            if (!daystring.equals("")) {
                GUIEvent.drawText(fontRenderer, guiGraphics, daystring, daycoord, heightoffset + 10, rgb, ConfigHandler.drawTextShadow);
            }
        }
        poseStack.popPose();
    }

    private static void drawText(Font font, GuiGraphics guiGraphics, String content, int x, int y, int rgb, boolean drawShadow) {
        guiGraphics.drawString(font, (Component)Component.literal((String)content), x, y, rgb, drawShadow);
    }

    private static String getGameTime() {
        int gametime = (int)GUIEvent.mc.level.getDayTime();
        int daysplayed = 0;
        while (gametime >= 24000) {
            gametime -= 24000;
            ++daysplayed;
        }
        if (ConfigHandler.showDaysPlayedWorld) {
            daystring = "Day " + daysplayed;
        }
        int time = gametime >= 18000 ? gametime - 18000 : 6000 + gametime;
        String suffix = "";
        if (!ConfigHandler._24hourformat) {
            if (time >= 13000) {
                time -= 12000;
                suffix = " PM";
            } else if (time >= 12000) {
                suffix = " PM";
            } else {
                suffix = " AM";
                if (time <= 999) {
                    time += 12000;
                }
            }
        }
        StringBuilder stringtime = new StringBuilder("" + time / 10);
        for (int n = stringtime.length(); n < 4; ++n) {
            stringtime.insert(0, "0");
        }
        String[] strsplit = stringtime.toString().split("");
        int minutes = (int)Math.floor(Double.parseDouble(strsplit[2] + strsplit[3]) / 100.0 * 60.0);
        String sm = "" + minutes;
        if (minutes < 10) {
            sm = "0" + minutes;
        }
        stringtime = !ConfigHandler._24hourformat && strsplit[0].equals("0") ? new StringBuilder(strsplit[1] + ":" + sm.charAt(0) + sm.charAt(1)) : new StringBuilder(strsplit[0] + strsplit[1] + ":" + sm.charAt(0) + sm.charAt(1));
        return String.valueOf(stringtime) + suffix;
    }
}

