/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.guiclock_common_fabric.events;

import com.natamus.collective_common_fabric.functions.GUIFunctions;
import com.natamus.collective_common_fabric.functions.StringFunctions;
import com.natamus.guiclock_common_fabric.config.ConfigHandler;
import java.awt.Color;
import java.util.Collection;
import net.minecraft.class_1041;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4081;
import net.minecraft.class_4587;
import net.minecraft.class_9779;

public class GUIEvent {
    private static final class_310 mc = class_310.method_1551();
    private static String daystring = "";

    public static void renderOverlay(class_332 guiGraphics, class_9779 deltaTracker) {
        Collection activeeffects;
        if (GUIFunctions.shouldHideGUI()) {
            return;
        }
        boolean gametimeb = ConfigHandler.mustHaveClockInInventoryForGameTime;
        boolean realtimeb = ConfigHandler.mustHaveClockInInventoryForRealTime;
        boolean found = true;
        if ((gametimeb || realtimeb) && !(found = GUIEvent.mc.field_1724.method_6079().method_7909().equals(class_1802.field_8557))) {
            class_1661 inv = GUIEvent.mc.field_1724.method_31548();
            for (int n = 0; n <= 35; ++n) {
                if (!inv.method_5438(n).method_7909().equals(class_1802.field_8557)) continue;
                found = true;
                break;
            }
        }
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        class_327 fontRenderer = GUIEvent.mc.field_1772;
        class_1041 scaled = mc.method_22683();
        int width = scaled.method_4486();
        int heightoffset = ConfigHandler.clockHeightOffset;
        if (heightoffset < 5) {
            heightoffset = 5;
        }
        if (ConfigHandler.lowerClockWhenPlayerHasEffects && (activeeffects = GUIEvent.mc.field_1724.method_6026()).size() > 0) {
            boolean haspositive = false;
            boolean hasnegative = false;
            for (class_1293 effect : activeeffects) {
                if (!effect.method_5581()) continue;
                if (((class_1291)effect.method_5579().comp_349()).method_18792().equals((Object)class_4081.field_18271)) {
                    haspositive = true;
                } else {
                    hasnegative = true;
                }
                if (!haspositive || !hasnegative) continue;
                break;
            }
            if (hasnegative && haspositive) {
                heightoffset += 50;
            } else if (haspositive && !hasnegative) {
                heightoffset += 25;
            }
        }
        if (ConfigHandler.showOnlyMinecraftClockIcon) {
            if (gametimeb && !found) {
                return;
            }
            int xcoord = ConfigHandler.clockPositionIsLeft ? 20 : (ConfigHandler.clockPositionIsCenter ? width / 2 - 8 : width - 20);
            guiGraphics.method_51427(new class_1799((class_1935)class_1802.field_8557), xcoord += ConfigHandler.clockWidthOffset, heightoffset);
        } else {
            int daycoord;
            Object time;
            String realtime = StringFunctions.getPCLocalTime((boolean)ConfigHandler._24hourformat, (boolean)ConfigHandler.showRealTimeSeconds);
            if (ConfigHandler.showBothTimes) {
                if (gametimeb && realtimeb) {
                    if (!found) {
                        return;
                    }
                    time = GUIEvent.getGameTime() + " | " + realtime;
                } else {
                    time = !found && gametimeb ? realtime : (!found && realtimeb ? GUIEvent.getGameTime() : GUIEvent.getGameTime() + " | " + realtime);
                }
            } else if (ConfigHandler.showRealTime) {
                if (realtimeb && !found) {
                    return;
                }
                time = realtime;
            } else {
                if (gametimeb && !found) {
                    return;
                }
                time = GUIEvent.getGameTime();
            }
            if (((String)time).equals("")) {
                return;
            }
            int stringWidth = fontRenderer.method_1727((String)time);
            int daystringWidth = fontRenderer.method_1727(daystring);
            Color colour = new Color(ConfigHandler.RGB_R, ConfigHandler.RGB_G, ConfigHandler.RGB_B, 255);
            if (ConfigHandler.clockPositionIsLeft) {
                xcoord = 5;
                daycoord = 5;
            } else if (ConfigHandler.clockPositionIsCenter) {
                xcoord = width / 2 - stringWidth / 2;
                daycoord = width / 2 - daystringWidth / 2;
            } else {
                xcoord = width - stringWidth - 5;
                daycoord = width - daystringWidth - 5;
            }
            daycoord += ConfigHandler.clockWidthOffset;
            int rgb = colour.getRGB();
            GUIEvent.drawText(fontRenderer, guiGraphics, (String)time, xcoord += ConfigHandler.clockWidthOffset, heightoffset, rgb, ConfigHandler.drawTextShadow);
            if (!daystring.equals("")) {
                GUIEvent.drawText(fontRenderer, guiGraphics, daystring, daycoord, heightoffset + 10, rgb, ConfigHandler.drawTextShadow);
            }
        }
        poseStack.method_22909();
    }

    private static void drawText(class_327 font, class_332 guiGraphics, String content, int x, int y, int rgb, boolean drawShadow) {
        guiGraphics.method_51439(font, (class_2561)class_2561.method_43470((String)content), x, y, rgb, drawShadow);
    }

    private static String getGameTime() {
        int gametime = (int)GUIEvent.mc.field_1687.method_8532();
        int daysplayed = 0;
        while (gametime >= 24000) {
            gametime -= 24000;
            ++daysplayed;
        }
        if (ConfigHandler.showDaysPlayedWorld) {
            daystring = "Day " + daysplayed;
        }
        int time = gametime >= 18000 ? gametime - 18000 : 6000 + gametime;
        String suffix = "";
        if (!ConfigHandler._24hourformat) {
            if (time >= 13000) {
                time -= 12000;
                suffix = " PM";
            } else if (time >= 12000) {
                suffix = " PM";
            } else {
                suffix = " AM";
                if (time <= 999) {
                    time += 12000;
                }
            }
        }
        StringBuilder stringtime = new StringBuilder("" + time / 10);
        for (int n = stringtime.length(); n < 4; ++n) {
            stringtime.insert(0, "0");
        }
        String[] strsplit = stringtime.toString().split("");
        int minutes = (int)Math.floor(Double.parseDouble(strsplit[2] + strsplit[3]) / 100.0 * 60.0);
        String sm = "" + minutes;
        if (minutes < 10) {
            sm = "0" + minutes;
        }
        stringtime = !ConfigHandler._24hourformat && strsplit[0].equals("0") ? new StringBuilder(strsplit[1] + ":" + sm.charAt(0) + sm.charAt(1)) : new StringBuilder(strsplit[0] + strsplit[1] + ":" + sm.charAt(0) + sm.charAt(1));
        return String.valueOf(stringtime) + suffix;
    }
}

