/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.spelllib.item;

import com.gametechbc.spelllib.item.GeoArmorItem;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.IPresetSpellContainer;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.ISpellContainerMutable;
import io.redspace.ironsspellbooks.item.weapons.AttributeContainer;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractImbuableArmorItem
extends GeoArmorItem
implements IPresetSpellContainer {
    public AbstractImbuableArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, AttributeContainer ... attributes) {
        super(material, type, properties, attributes);
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            if (this.getImbuableArmorTypes().contains(armorItem.getType()) && !ISpellContainer.isSpellContainer((ItemStack)itemStack)) {
                int slots = this.getMaxSpellSlots().getOrDefault(armorItem.getType(), 0);
                ISpellContainerMutable spellContainer = ISpellContainer.create((int)slots, (boolean)this.isAddToSpellWheel(), (boolean)this.mustBeEquipped()).mutableCopy();
                Map spells = this.getSpellsToAdd().getOrDefault(armorItem.getType(), Collections.emptyMap());
                int index = 0;
                for (Map.Entry entry : spells.entrySet()) {
                    AbstractSpell spell = (AbstractSpell)entry.getKey();
                    SpellData data = (SpellData)entry.getValue();
                    spellContainer.addSpellAtIndex(spell, data.level, index++, data.unlocked);
                }
                itemStack.set((Supplier)ComponentRegistry.SPELL_CONTAINER, (Object)spellContainer.toImmutable());
            }
        }
    }

    protected abstract Set<ArmorItem.Type> getImbuableArmorTypes();

    protected abstract Map<ArmorItem.Type, Integer> getMaxSpellSlots();

    protected Map<ArmorItem.Type, Map<AbstractSpell, SpellData>> getSpellsToAdd() {
        return Collections.emptyMap();
    }

    protected boolean isAddToSpellWheel() {
        return true;
    }

    protected boolean mustBeEquipped() {
        return true;
    }

    public static class SpellData {
        public final int level;
        public final boolean unlocked;

        public SpellData(int level, boolean unlocked) {
            this.level = level;
            this.unlocked = unlocked;
        }
    }
}

