/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.grindstonesharpertools_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.grindstonesharpertools_common_neoforge.config.ConfigHandler;
import com.natamus.grindstonesharpertools_common_neoforge.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.phys.BlockHitResult;

public class GrindEvent {
    public static float onDamage(Level world, Entity entity, DamageSource damageSource, float damageAmount) {
        CompoundTag nbtc;
        CustomData customData;
        Entity source = damageSource.getEntity();
        if (source == null) {
            return damageAmount;
        }
        if (world.isClientSide) {
            return damageAmount;
        }
        if (!(source instanceof Player)) {
            return damageAmount;
        }
        Player player = (Player)source;
        ItemStack hand = player.getMainHandItem();
        if ((Services.TOOLFUNCTIONS.isTool(hand) || Services.TOOLFUNCTIONS.isSword(hand)) && (customData = (CustomData)hand.get(DataComponents.CUSTOM_DATA)) != null && (nbtc = customData.getUnsafe()).contains("sharper")) {
            int sharpLeft = nbtc.getInt("sharper");
            if (!player.isCreative() || !ConfigHandler.infiniteCreativeUses) {
                --sharpLeft;
            }
            if (sharpLeft > 0) {
                nbtc.putInt("sharper", sharpLeft);
                double modifier = ConfigHandler.sharpenedDamageModifier;
                damageAmount *= (float)modifier;
                if (ConfigHandler.sendUsesLeftInChat) {
                    int totalUses = ConfigHandler.usesAfterGrinding;
                    if ((double)sharpLeft == (double)totalUses * 0.75) {
                        MessageFunctions.sendMessage((Player)player, (String)"Your sharpened tool has 75% of its uses left.", (ChatFormatting)ChatFormatting.BLUE);
                    } else if ((double)sharpLeft == (double)totalUses * 0.5) {
                        MessageFunctions.sendMessage((Player)player, (String)"Your sharpened tool has 50% of its uses left.", (ChatFormatting)ChatFormatting.BLUE);
                    } else if ((double)sharpLeft == (double)totalUses * 0.25) {
                        MessageFunctions.sendMessage((Player)player, (String)"Your sharpened tool has 25% of its uses left.", (ChatFormatting)ChatFormatting.BLUE);
                    } else if ((double)sharpLeft == (double)totalUses * 0.1) {
                        MessageFunctions.sendMessage((Player)player, (String)"Your sharpened tool has 10% of its uses left.", (ChatFormatting)ChatFormatting.BLUE);
                    }
                }
            } else {
                nbtc.remove("sharper");
                MessageFunctions.sendMessage((Player)player, (String)"Your tool is no longer sharpened.", (ChatFormatting)ChatFormatting.RED);
            }
            hand.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbtc));
            Util.updateName(hand, sharpLeft);
        }
        return damageAmount;
    }

    public static boolean onClick(Level world, Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitVec) {
        ItemStack itemstack;
        if (world.isClientSide || !hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return true;
        }
        Block block = world.getBlockState(pos).getBlock();
        if (block instanceof GrindstoneBlock && player.isCrouching() && (Services.TOOLFUNCTIONS.isTool(itemstack = player.getItemInHand(hand)) || Services.TOOLFUNCTIONS.isSword(itemstack))) {
            CompoundTag nbtc = new CompoundTag();
            CustomData customData = (CustomData)itemstack.get(DataComponents.CUSTOM_DATA);
            if (customData != null) {
                nbtc = customData.getUnsafe();
            }
            int sharpeneduses = ConfigHandler.usesAfterGrinding;
            nbtc.putInt("sharper", sharpeneduses);
            itemstack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbtc));
            Util.updateName(itemstack, sharpeneduses);
            MessageFunctions.sendMessage((Player)player, (String)("Your tool has been sharpened with " + sharpeneduses + " uses."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            return false;
        }
        return true;
    }
}

