/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.status.effect.impl;

import mod.azure.azurelib.core.object.Color;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.sound.GigSounds;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.util.DamageSourceUtils;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class ImpregnationStatusEffect
extends MobEffect {
    public ImpregnationStatusEffect() {
        super(MobEffectCategory.HARMFUL, Color.DARK_GRAY.getColor());
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public void onEffectAdded(LivingEntity livingEntity, int amplifier) {
        if (GigEntityUtils.isTargetHostable((Entity)livingEntity) && this == GigStatusEffects.IMPREGNATION) {
            this.handleStatusEffects(livingEntity, (int)CommonMod.config.impregnationTickTimer, MobEffects.HUNGER, MobEffects.WEAKNESS, MobEffects.DIG_SLOWDOWN);
        }
        super.onEffectAdded(livingEntity, amplifier);
    }

    @SafeVarargs
    private void handleStatusEffects(@NotNull LivingEntity livingEntity, int ticks, Holder<MobEffect> ... statusEffects) {
        for (Holder<MobEffect> effect : statusEffects) {
            if (livingEntity.hasEffect(effect)) continue;
            livingEntity.addEffect(new MobEffectInstance(effect, ticks, 3, true, true));
        }
    }

    public static void effectRemoval(LivingEntity entity, MobEffectInstance mobEffectInstance) {
        Mob mob;
        if (Constants.isCreativeSpecPlayer.test((Entity)entity)) {
            return;
        }
        if (!GigEntityUtils.isTargetHostable((Entity)entity)) {
            return;
        }
        if (entity.level().isClientSide || !(mobEffectInstance.getEffect().value() instanceof ImpregnationStatusEffect)) {
            return;
        }
        if (entity instanceof Mob && (mob = (Mob)entity).isNoAi()) {
            return;
        }
        if (entity.hasEffect(GigStatusEffects.TRAUMA)) {
            return;
        }
        LivingEntity burster = GigEntityUtils.spawnBurster(entity);
        if (burster != null) {
            ImpregnationStatusEffect.setBursterProperties(entity, burster);
            entity.level().addFreshEntity((Entity)burster);
            entity.level().playSound((Entity)entity, entity.blockPosition(), GigSounds.CHESTBURSTING.get(), SoundSource.NEUTRAL, 2.0f, 1.0f);
            if (Constants.isNotCreativeSpecPlayer.test((Entity)entity)) {
                DamageSourceUtils.damageArmor(entity.getItemBySlot(EquipmentSlot.CHEST), entity.getRandom(), 5, 10);
            }
            entity.hurt(GigDamageSources.of(entity.level(), GigDamageSources.CHESTBURSTING), Float.MAX_VALUE);
        }
    }

    private static void setBursterProperties(LivingEntity entity, LivingEntity burster) {
        if (entity.hasCustomName()) {
            burster.setCustomName(entity.getCustomName());
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = entity;
            for (MobEffectInstance effect : livingEntity.getActiveEffects()) {
                burster.addEffect(new MobEffectInstance(effect));
            }
        }
        burster.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 10), (Entity)burster);
        burster.setPos(entity.getX(), entity.getY(), entity.getZ());
    }
}

