/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.fluid;

import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.fluid.GigFluids;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public abstract class BlackFluid
extends FlowingFluid {
    public boolean isSame(@NotNull Fluid fluid) {
        return fluid == GigFluids.BLACK_FLUID_STILL.get() || fluid == GigFluids.BLACK_FLUID_FLOWING.get();
    }

    @NotNull
    public Item getBucket() {
        return Items.BUCKET;
    }

    public boolean canBeReplacedWith(@NotNull FluidState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Fluid fluid, @NotNull Direction direction) {
        return false;
    }

    public int getTickDelay(@NotNull LevelReader world) {
        return 20;
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    @NotNull
    protected BlockState createLegacyBlock(@NotNull FluidState state) {
        return (BlockState)GigBlocks.BLACK_FLUID.get().defaultBlockState().setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(BlackFluid.getLegacyLevel((FluidState)state)));
    }

    @NotNull
    public Fluid getFlowing() {
        return (Fluid)GigFluids.BLACK_FLUID_FLOWING.get();
    }

    @NotNull
    public Fluid getSource() {
        return (Fluid)GigFluids.BLACK_FLUID_STILL.get();
    }

    protected void beforeDestroyingBlock(@NotNull LevelAccessor world, @NotNull BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.hasBlockEntity() ? world.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    protected int getSlopeFindDistance(@NotNull LevelReader world) {
        return 2;
    }

    protected int getDropOff(@NotNull LevelReader world) {
        return 2;
    }

    protected void randomTick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull FluidState fluidState, RandomSource randomSource) {
        if (randomSource.nextInt(50) > 40) {
            for (int x = -5; x <= 5; ++x) {
                block1: for (int y = -5; y <= 5; ++y) {
                    for (int z = -5; z <= 5; ++z) {
                        BlockState targetBlockState;
                        BlockPos targetPos = blockPos.offset(x, y, z);
                        if (!level.isLoaded(targetPos) || (targetBlockState = level.getBlockState(targetPos)).getBlock() instanceof TallGrassBlock || !targetBlockState.getFluidState().isEmpty() || !targetBlockState.is(GigTags.SPORE_REPLACE) || level.getBlockState(targetPos.below()).isAir()) continue;
                        level.setBlockAndUpdate(targetPos, GigBlocks.SPORE_BLOCK.get().defaultBlockState());
                        continue block1;
                    }
                }
            }
        }
    }

    protected boolean isRandomlyTicking() {
        return true;
    }

    public static class Still
    extends BlackFluid {
        public int getAmount(@NotNull FluidState fluidState) {
            return 8;
        }

        public boolean isSource(@NotNull FluidState fluidState) {
            return true;
        }

        protected boolean canConvertToSource(@NotNull Level level) {
            return false;
        }
    }

    public static class Flowing
    extends BlackFluid {
        public void createFluidStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState fluidState) {
            return (Integer)fluidState.getValue((Property)LEVEL);
        }

        public boolean isSource(@NotNull FluidState fluidState) {
            return false;
        }

        protected boolean canConvertToSource(@NotNull Level level) {
            return false;
        }
    }
}

