/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.mutant;

import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.BreakBlocksGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.DelayedAttackGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.LungeAtTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.DigToTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.DodgeProjectilesGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FindDarknessGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFightGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFireGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.StrollAroundInWaterGoal;
import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import mods.cybercat.gigeresque.common.entity.helper.AzureVibrationUser;
import mods.cybercat.gigeresque.common.entity.helper.GigCommonMethods;
import mods.cybercat.gigeresque.common.entity.helper.GigMeleeAttackSelector;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.DamageSourceUtils;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class StalkerEntity
extends AlienEntity {
    public StalkerEntity(EntityType<? extends AlienEntity> entityType, Level world) {
        super(entityType, world);
        this.vibrationUser = new AzureVibrationUser(this, 1.9f);
        this.animationDispatcher = new AnimationDispatcher((Entity)this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
        this.animationSelector = GigMeleeAttackSelector.STALKER_ANIM_SELECTOR;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, CommonMod.config.stalkerConfigs.stalkerXenoHealth).add(Attributes.ARMOR, CommonMod.config.stalkerConfigs.stalkerXenoArmor).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, 0.3300000041723251).add(Attributes.ATTACK_DAMAGE, CommonMod.config.stalkerConfigs.stalkerAttackDamage).add(Attributes.ATTACK_KNOCKBACK, 0.3);
    }

    @Override
    public int getAcidDiameter() {
        return 3;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new DodgeProjectilesGoal(this));
        this.goalSelector.addGoal(1, (Goal)new StrollAroundInWaterGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new DelayedAttackGoal(this, 1.1f, 5));
        this.goalSelector.addGoal(1, (Goal)new FleeFightGoal(this));
        this.goalSelector.addGoal(3, (Goal)new LungeAtTargetGoal((Mob)this, 0.05f, 200, 16.0).setOnLungeCallback(() -> this.runLungeAnimation()));
        this.goalSelector.addGoal(4, (Goal)new BreakBlocksGoal(this, GigTags.DESTRUCTIBLE_LIGHT, 1.5f));
        this.goalSelector.addGoal(5, (Goal)new DigToTargetGoal(this, 32.0));
        this.goalSelector.addGoal(5, (Goal)new FleeFireGoal(this));
        this.goalSelector.addGoal(7, (Goal)new FindDarknessGoal(this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 15.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AlienEntity.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> this.getHealth() > this.getMaxHealth() / 2.0f && GigEntityUtils.removeTarget(target)));
    }

    @Override
    public void tick() {
        super.tick();
        this.moveAnalysis.update();
    }

    @Override
    public void die(@NotNull DamageSource source) {
        if (!this.level().isClientSide && this.random.nextInt(5) == 0) {
            BlockPos.betweenClosedStream((AABB)this.getBoundingBox().inflate(10.0)).forEach(pos -> {
                BlockState blockState = this.level().getBlockState(pos);
                if (blockState.is(GigTags.SPORE_REPLACE)) {
                    this.level().setBlockAndUpdate(pos, GigBlocks.SPORE_BLOCK.get().defaultBlockState());
                }
            });
        }
        if (!this.level().isClientSide && this.random.nextInt(10) == 0) {
            BlockPos.betweenClosedStream((AABB)this.getBoundingBox().inflate(10.0)).forEach(pos -> {
                BlockState blockState = this.level().getBlockState(pos);
                if (blockState.is(Blocks.WATER)) {
                    this.level().setBlockAndUpdate(pos, GigBlocks.BLACK_FLUID.get().defaultBlockState());
                }
            });
        }
        super.die(source);
    }

    @Override
    public boolean hurt(@NotNull DamageSource source, float amount) {
        if (!this.level().isClientSide) {
            Entity attacker = source.getEntity();
            if (source.getEntity() != null && attacker instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)attacker;
                this.brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)living);
            }
        }
        if (DamageSourceUtils.isDamageSourceNotPuncturing(source, this.damageSources())) {
            return super.hurt(source, amount);
        }
        if (!this.level().isClientSide && source != this.damageSources().genericKill()) {
            if (this.getAcidDiameter() == 1) {
                GigCommonMethods.generateGooBlood((LivingEntity)this, this.blockPosition(), 0, 0);
            } else {
                int radius = (this.getAcidDiameter() - 1) / 2;
                for (int i = 0; i < this.getAcidDiameter(); ++i) {
                    int x = this.level().getRandom().nextInt(this.getAcidDiameter()) - radius;
                    int z = this.level().getRandom().nextInt(this.getAcidDiameter()) - radius;
                    if (source == this.damageSources().genericKill() && source == this.damageSources().generic()) continue;
                    GigCommonMethods.generateGooBlood((LivingEntity)this, this.blockPosition(), x, z);
                }
            }
        }
        return super.hurt(source, amount);
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            if (!this.level().isClientSide && this.getRandom().nextInt(0, 10) > 7) {
                livingEntity.hurt(this.damageSources().mobAttack((LivingEntity)this), this.getRandom().nextInt(4) > 2 ? CommonMod.config.stalkerConfigs.stalkerTailAttackDamage : 0.0f);
                this.heal(1.0833f);
            }
        }
        this.heal(1.0833f);
        return super.doHurtTarget(target);
    }
}

