/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.misc;

import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.BreakBlocksGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.DelayedAttackGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.LungeAtTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.SpitAcidGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.DigToTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.DodgeProjectilesGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FindDarknessGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeExplodingCreeperGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFightGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFireGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.StrollAroundInWaterGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.nest.BuildNestGoal;
import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import mods.cybercat.gigeresque.common.entity.helper.AzureVibrationUser;
import mods.cybercat.gigeresque.common.entity.helper.GigMeleeAttackSelector;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpitterEntity
extends AlienEntity {
    public SpitterEntity(EntityType<? extends AlienEntity> entityType, Level world) {
        super(entityType, world);
        this.animationDispatcher = new AnimationDispatcher((Entity)this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
        this.vibrationUser = new AzureVibrationUser(this, 1.3f);
        this.animationSelector = GigMeleeAttackSelector.STANDARD_ANIM_SELECTOR;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, CommonMod.config.spitterConfigs.spitterXenoHealth).add(Attributes.ARMOR, CommonMod.config.spitterConfigs.spitterXenoArmor).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, (double)0.23f).add(Attributes.ATTACK_DAMAGE, CommonMod.config.spitterConfigs.spitterAttackDamage).add(Attributes.ATTACK_KNOCKBACK, 0.3);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FleeExplodingCreeperGoal(this));
        this.goalSelector.addGoal(0, (Goal)new DodgeProjectilesGoal(this));
        this.goalSelector.addGoal(1, (Goal)new StrollAroundInWaterGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new SpitAcidGoal(this, 1.3f, 5));
        this.goalSelector.addGoal(1, (Goal)new DelayedAttackGoal(this, 1.3f, 5));
        this.goalSelector.addGoal(1, (Goal)new FleeFightGoal(this));
        this.goalSelector.addGoal(3, (Goal)new LungeAtTargetGoal((Mob)this, 0.05f, 200, 16.0).setOnLungeCallback(() -> this.runLungeAnimation()));
        this.goalSelector.addGoal(4, (Goal)new BreakBlocksGoal(this, GigTags.DESTRUCTIBLE_LIGHT, 1.5f));
        this.goalSelector.addGoal(5, (Goal)new DigToTargetGoal(this, 32.0));
        this.goalSelector.addGoal(5, (Goal)new FleeFireGoal(this));
        this.goalSelector.addGoal(7, (Goal)new BuildNestGoal(this));
        this.goalSelector.addGoal(7, (Goal)new FindDarknessGoal(this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 15.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AlienEntity.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> this.getHealth() > this.getMaxHealth() / 2.0f && GigEntityUtils.removeTarget(target)));
    }

    @Override
    public void tick() {
        super.tick();
        this.moveAnalysis.update();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType != MobSpawnType.NATURAL) {
            this.setGrowth(this.getMaxGrowth());
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        if (this.wasEyeInWater) {
            return EntityDimensions.scalable((float)3.0f, (float)1.0f);
        }
        return EntityDimensions.scalable((float)0.9f, (float)(this.crawlingManager.isCrawling() ? 0.4f : 2.9f));
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            if (!this.level().isClientSide && this.getRandom().nextInt(0, 10) > 7) {
                if (livingEntity instanceof Player) {
                    Player playerEntity = (Player)livingEntity;
                    playerEntity.drop(playerEntity.getInventory().getSelected(), false);
                    playerEntity.getInventory().setItem(playerEntity.getInventory().selected, ItemStack.EMPTY);
                }
                if (livingEntity instanceof Mob) {
                    Mob mobEntity = (Mob)livingEntity;
                    mobEntity.getMainHandItem();
                    this.drop((LivingEntity)mobEntity, mobEntity.getMainHandItem());
                    mobEntity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.AIR));
                }
                livingEntity.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 1.0f, 1.0f);
                livingEntity.hurt(this.damageSources().mobAttack((LivingEntity)this), this.getRandom().nextInt(4) > 2 ? CommonMod.config.spitterConfigs.spitterXenoTailAttackDamage : 0.0f);
                this.heal(1.0833f);
                return super.doHurtTarget(target);
            }
        }
        this.heal(1.0833f);
        return super.doHurtTarget(target);
    }
}

