/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.misc;

import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.helper.GigCommonMethods;
import mods.cybercat.gigeresque.common.entity.helper.Growable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AquaEggEntity
extends Entity
implements Growable {
    private static final EntityDataAccessor<Float> GROWTH = SynchedEntityData.defineId(AquaEggEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public float growthCounter = 0.0f;

    public AquaEggEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.setYRot(this.random.nextFloat() * 360.0f);
    }

    public void tick() {
        super.tick();
        if (this.level() instanceof ServerLevel && this.isAlive()) {
            if (this.getGrowth() <= this.getMaxGrowth() && this.tickCount % 20 == 0) {
                float f = this.growthCounter;
                this.growthCounter = f + 1.0f;
                this.setGrowth((this.getGrowth() + f) * this.getGrowthMultiplier());
            } else if (this.getGrowth() >= this.getMaxGrowth()) {
                this.growUp(this);
            }
        }
        GigCommonMethods.handleFloatingPhysics(this);
        GigCommonMethods.handleCollisionPhysics(this);
        GigCommonMethods.handleMovement(this);
    }

    @NotNull
    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public float getMaxGrowth() {
        return 600.0f;
    }

    @Override
    public LivingEntity growInto() {
        return (LivingEntity)GigEntities.FACEHUGGER.get().create(this.level());
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        builder.define(GROWTH, (Object)Float.valueOf(0.0f));
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        this.setGrowth(compound.getFloat("growth"));
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        compound.putFloat("growth", this.getGrowth());
    }

    @Override
    public float getGrowth() {
        return ((Float)this.entityData.get(GROWTH)).floatValue();
    }

    @Override
    public void setGrowth(float growth) {
        this.growthCounter = growth;
        this.entityData.set(GROWTH, (Object)Float.valueOf(growth));
    }

    public boolean isAttackable() {
        return false;
    }

    @NotNull
    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }

    public float getVisualRotationYInDegrees() {
        return 180.0f - (((float)this.tickCount + 0.5f) / 20.0f + this.random.nextFloat() * (float)Math.PI * 2.0f) / ((float)Math.PI * 2) * 360.0f;
    }
}

