/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.classic;

import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.FacehuggerRunToTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.LungeAtTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeExplodingCreeperGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFightGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFireGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.StrollAroundInWaterGoal;
import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import mods.cybercat.gigeresque.common.entity.helper.AzureVibrationUser;
import mods.cybercat.gigeresque.common.entity.helper.GigCommonMethods;
import mods.cybercat.gigeresque.common.entity.helper.GigMeleeAttackSelector;
import mods.cybercat.gigeresque.common.sound.GigSounds;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class FacehuggerEntity
extends AlienEntity {
    private static final EntityDataAccessor<Boolean> IS_INFERTILE = SynchedEntityData.defineId(FacehuggerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float ticksAttachedToHost = -1.0f;

    public FacehuggerEntity(EntityType<? extends AlienEntity> type, Level world) {
        super(type, world);
        this.animationDispatcher = new AnimationDispatcher((Entity)this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
        this.vibrationUser = new AzureVibrationUser(this, 1.0f);
        this.animationSelector = GigMeleeAttackSelector.HUGGER_SELECTOR;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, CommonMod.config.facehuggerHealth).add(Attributes.ARMOR, 1.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MOVEMENT_SPEED, 0.3300000041723251);
    }

    @Override
    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 60) {
            this.remove(Entity.RemovalReason.KILLED);
            super.tickDeath();
            this.dropExperience((Entity)this);
        }
    }

    @Override
    public int getAcidDiameter() {
        return this.isPassenger() ? 0 : 1;
    }

    public boolean isInfertile() {
        return (Boolean)this.entityData.get(IS_INFERTILE);
    }

    public void setIsInfertile(boolean value) {
        this.entityData.set(IS_INFERTILE, (Object)value);
    }

    @Override
    public void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_INFERTILE, (Object)false);
    }

    public void detachFromHost() {
        this.ticksAttachedToHost = -1.0f;
        this.unRide();
    }

    public boolean isAttachedToHost() {
        return this.getVehicle() instanceof LivingEntity && this.getVehicle().isAlive();
    }

    @Override
    public int calculateFallDamage(float fallDistance, float damageMultiplier) {
        if (fallDistance <= 12.0f) {
            return 0;
        }
        return super.calculateFallDamage(fallDistance, damageMultiplier);
    }

    @Override
    public int getMaxFallDistance() {
        return 12;
    }

    public void grabTarget(LivingEntity entity) {
        ServerPlayer player;
        this.startRiding((Entity)entity, true);
        this.setAggressive(false);
        entity.setSpeed(0.0f);
        if (CommonMod.config.facehuggerConfigs.facehuggerGivesBlindness) {
            entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, (int)CommonMod.config.getFacehuggerAttachTickTimer(), 0));
        }
        if (!(!(entity instanceof ServerPlayer) || (player = (ServerPlayer)entity).isCreative() && player.isSpectator())) {
            player.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)entity));
        }
    }

    public void handleAttachmentToHost() {
        if (this.isAttachedToHost()) {
            Player player;
            Entity entity;
            this.ticksAttachedToHost += 1.0f;
            Entity host = this.getVehicle();
            if (!(host instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)host;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 1000, 10, false, false));
            if (livingEntity.getHealth() > livingEntity.getMaxHealth()) {
                livingEntity.heal(6.0f);
            }
            if ((entity = this.getVehicle()) instanceof Player && (player = (Player)entity).getFoodData().needsFood()) {
                player.getFoodData().setFoodLevel(20);
            }
            if (this.ticksAttachedToHost > CommonMod.config.getFacehuggerAttachTickTimer()) {
                Entity entity2 = this.getVehicle();
                if (entity2 instanceof Player && (player = (Player)entity2) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(Constants.modResource("facehugged"));
                    if (advancement != null && !serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone()) {
                        for (String s : serverPlayer.getAdvancements().getOrStartProgress(advancement).getRemainingCriteria()) {
                            serverPlayer.getAdvancements().award(advancement, s);
                        }
                    }
                }
                if (livingEntity.hasEffect(MobEffects.BLINDNESS)) {
                    livingEntity.removeEffect(MobEffects.BLINDNESS);
                }
                if (!livingEntity.hasEffect(GigStatusEffects.IMPREGNATION)) {
                    livingEntity.addEffect(new MobEffectInstance(GigStatusEffects.IMPREGNATION, (int)CommonMod.config.getImpregnationTickTimer(), 0, false, true));
                }
                if (!this.level().isClientSide) {
                    this.level().playSound((Entity)this, this.blockPosition(), GigSounds.HUGGER_IMPLANT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
                }
                this.setIsInfertile(true);
                this.unRide();
                this.hurt(this.damageSources().genericKill(), Float.MAX_VALUE);
            }
            if (livingEntity.hasEffect(GigStatusEffects.IMPREGNATION)) {
                if (livingEntity.hasEffect(MobEffects.BLINDNESS)) {
                    livingEntity.removeEffect(MobEffects.BLINDNESS);
                }
                this.detachFromHost();
                this.setIsInfertile(true);
                this.kill();
            }
            if (Constants.isCreativeSpecPlayer.test(host)) {
                this.detachFromHost();
                this.setIsInfertile(true);
                this.kill();
            }
        } else {
            this.ticksAttachedToHost = -1.0f;
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.moveAnalysis.update();
        this.setGrowth(0.0f);
        if (this.getTarget() != null && !GigEntityUtils.faceHuggerTest(this.getTarget())) {
            this.setTarget(null);
        }
        if (this.getTarget() != null && !this.getTarget().getUseItem().is(Items.SHIELD) && this.getBoundingBox().intersects(this.getTarget().getBoundingBox()) && GigEntityUtils.faceHuggerTest(this.getTarget())) {
            this.grabTarget(this.getTarget());
        }
        if (this.getTarget() != null && !this.level().getEntitiesOfClass(Mob.class, this.getBoundingBox().inflate(5.0), entity -> GigEntityUtils.faceHuggerTest((LivingEntity)entity) && entity.getUseItem().is(Items.SHIELD)).isEmpty()) {
            this.grabTarget(this.getTarget());
        }
        if (this.isAttachedToHost() && !this.isDeadOrDying()) {
            GigCommonMethods.setAnimation(this.animationDispatcher::sendImpregate);
        }
        if (this.getVehicle() != null && !this.getVehicle().isAlive() && this.isAlive()) {
            this.stopRiding();
            GigCommonMethods.setAnimation(this.animationDispatcher::sendStunned);
            this.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 60, 10, false, false));
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 10, false, false));
        }
        this.handleAttachmentToHost();
        if (this.isInfertile()) {
            GigCommonMethods.setAnimation(this.animationDispatcher::sendDeath);
            this.kill();
            this.removeAllGoals(goals -> true);
            this.getBrain().removeAllBehaviors();
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("isInfertile", this.isInfertile());
        nbt.putFloat("ticksAttachedToHost", this.ticksAttachedToHost);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("isInfertile")) {
            this.setIsInfertile(nbt.getBoolean("isInfertile"));
        }
        if (nbt.contains("ticksAttachedToHost")) {
            this.ticksAttachedToHost = nbt.getFloat("ticksAttachedToHost");
        }
    }

    @Override
    public boolean hurt(@NotNull DamageSource source, float amount) {
        Entity entity;
        if ((this.isAttachedToHost() || this.isInfertile()) && source == this.damageSources().drown()) {
            return false;
        }
        if (!this.level().isClientSide && source.getEntity() != null && (entity = source.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)livingEntity);
        }
        return super.hurt(source, amount);
    }

    public void knockback(double strength, double x, double z) {
        if (!this.isInfertile()) {
            super.knockback(strength, x, z);
        }
    }

    @Override
    @NotNull
    public SoundEvent getHurtSound(@NotNull DamageSource source) {
        return this.isAttachedToHost() || this.isInfertile() ? SoundEvents.EMPTY : GigSounds.HUGGER_HURT.get();
    }

    @Override
    @NotNull
    public SoundEvent getDeathSound() {
        return this.isAttachedToHost() || this.isInfertile() ? SoundEvents.EMPTY : GigSounds.HUGGER_DEATH.get();
    }

    protected void playStepSound(@NotNull BlockPos pos, @NotNull BlockState state) {
        this.playSound(SoundEvents.STRIDER_STEP, 0.05f, 10.0f);
    }

    public void stopRiding() {
        LivingEntity livingEntity;
        Entity entity;
        if (this.getVehicle() != null && (entity = this.getVehicle()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isAlive() && this.ticksAttachedToHost < 6000.0f && this.isUnderWater()) {
            return;
        }
        super.stopRiding();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FleeExplodingCreeperGoal(this));
        this.goalSelector.addGoal(1, (Goal)new StrollAroundInWaterGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.96));
        this.goalSelector.addGoal(1, (Goal)new FleeFightGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FacehuggerRunToTargetGoal(this, 1.3f, 0));
        this.goalSelector.addGoal(1, (Goal)new LungeAtTargetGoal((Mob)this, 0.75f, 40, 5.0).setOnLungeCallback(this::runLungeAnimation));
        this.goalSelector.addGoal(5, (Goal)new FleeFireGoal(this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 15.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AlienEntity.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> this.getHealth() > this.getMaxHealth() / 2.0f && GigEntityUtils.removeFaceHuggerTarget(target) && !this.hasEffect(MobEffects.CONFUSION)));
    }

    @Override
    protected void runLungeAnimation() {
        this.animationDispatcher.sendFacehuggerLunge();
    }
}

