/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.helper.managers;

import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.ai.nav.GigNavigation;
import mods.cybercat.gigeresque.common.entity.ai.nav.WaterMoveControl;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.pathfinder.PathType;

public class AlienNavigationManager {
    private final GroundPathNavigation groundNavigation;
    private final MoveControl groundMoveControl;
    private final WaterBoundPathNavigation waterNavigation;
    private final WaterMoveControl waterMoveControl;

    public AlienNavigationManager(AlienEntity xenomorph, MoveControl moveControl) {
        this.groundMoveControl = moveControl;
        this.groundNavigation = new GigNavigation((Mob)xenomorph, xenomorph.level());
        xenomorph.setPathfindingMalus(PathType.WATER, 0.0f);
        this.waterMoveControl = new WaterMoveControl(xenomorph);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)xenomorph, xenomorph.level());
    }

    public void switchToGround(AlienEntity xenomorph) {
        xenomorph.setMoveControl(this.groundMoveControl);
        xenomorph.setNavigation((PathNavigation)this.groundNavigation);
    }

    public void switchToWater(AlienEntity xenomorph) {
        xenomorph.setMoveControl(this.waterMoveControl);
        xenomorph.setNavigation((PathNavigation)this.waterNavigation);
    }
}

