/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.movement;

import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class FleeFireGoal
extends Goal {
    protected final AlienEntity mob;

    public FleeFireGoal(AlienEntity mob) {
        this.mob = mob;
    }

    public void start() {
        this.mob.setAggressive(false);
    }

    public void stop() {
        this.mob.setFleeingStatus(false);
    }

    public boolean canUse() {
        if (this.mob.stasisManager.isStasis()) {
            return false;
        }
        if (this.mob.level().dimensionType().piglinSafe()) {
            return false;
        }
        return this.mob.isAlive();
    }

    public void tick() {
        BlockPos mobPos = this.mob.blockPosition();
        int searchRadius = 5;
        boolean isLavaNearby = false;
        Vec3 runAwayDirection = new Vec3(0.0, 0.0, 0.0);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)mobPos.offset(-searchRadius, -1, -searchRadius), (BlockPos)mobPos.offset(searchRadius, 1, searchRadius))) {
            if (!this.mob.level().getBlockState(pos).is(GigTags.ALIEN_REPELLENTS)) continue;
            isLavaNearby = true;
            Vec3 lavaPos = Vec3.atCenterOf((Vec3i)pos);
            runAwayDirection = runAwayDirection.add(this.mob.position().subtract(lavaPos).normalize());
        }
        if (isLavaNearby && this.mob.getNavigation().isDone()) {
            this.mob.setFleeingStatus(true);
            Vec3 panicPos = this.mob.position().add(runAwayDirection.normalize().scale(20.0));
            Vec3 mobPosition = this.mob.position();
            Vec3 targetPos = mobPosition.add(panicPos);
            this.mob.getNavigation().moveTo(targetPos.x, targetPos.y, targetPos.z, 1.15);
        }
    }
}

