/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.movement;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class FleeExplodingCreeperGoal
extends Goal {
    private static final Predicate<Entity> IS_EXPLODING_SELECTOR = entity -> FleeExplodingCreeperGoal.isExplodingCreeper(entity) || entity.getType().is(GigTags.EXPLODING_ENTITY) || entity instanceof PrimedTnt;
    protected final AlienEntity alienEntity;
    protected final double speedModifier = 1.3;
    private Entity entityToAvoid;
    private Path path;

    public FleeExplodingCreeperGoal(AlienEntity alienEntity) {
        this.alienEntity = alienEntity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        List nearby = this.alienEntity.level().getEntities((Entity)this.alienEntity, this.alienEntity.getBoundingBox().inflate(9.0, 3.0, 9.0), IS_EXPLODING_SELECTOR);
        if (nearby.isEmpty()) {
            return false;
        }
        this.entityToAvoid = this.getNearest(nearby);
        Vec3 target = DefaultRandomPos.getPosAway((PathfinderMob)this.alienEntity, (int)16, (int)7, (Vec3)this.entityToAvoid.position());
        if (target == null) {
            return false;
        }
        if (this.entityToAvoid.distanceToSqr(target.x, target.y, target.z) < this.entityToAvoid.distanceToSqr((Entity)this.alienEntity)) {
            return false;
        }
        this.path = this.alienEntity.getNavigation().createPath(target.x, target.y, target.z, 0);
        return this.path != null;
    }

    public boolean canContinueToUse() {
        return this.alienEntity.getNavigation().isInProgress() && this.entityToAvoid.isAlive();
    }

    public boolean isInterruptable() {
        return false;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void start() {
        this.alienEntity.getNavigation().moveTo(this.path, 1.3);
        this.alienEntity.setFleeingStatus(true);
    }

    public void stop() {
        this.entityToAvoid = null;
        this.alienEntity.setFleeingStatus(false);
    }

    public void tick() {
        this.alienEntity.getNavigation().setSpeedModifier(1.3);
        this.alienEntity.setTarget(null);
    }

    private <T extends Entity> T getNearest(List<T> entities) {
        double nearestDistSqr = Double.POSITIVE_INFINITY;
        Entity nearest = null;
        for (Entity entity : entities) {
            double distSqr = this.alienEntity.distanceToSqr(entity);
            if (!(distSqr < nearestDistSqr)) continue;
            nearestDistSqr = distSqr;
            nearest = entity;
        }
        return (T)nearest;
    }

    private static boolean isExplodingCreeper(Entity entity) {
        if (!(entity instanceof Creeper)) {
            return false;
        }
        Creeper creeper = (Creeper)entity;
        return creeper.getSwellDir() > 0 || creeper.isIgnited();
    }
}

