/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.movement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.BlockBreakProgressManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DigToTargetGoal
extends Goal {
    private final AlienEntity mob;
    private final double reachDistance;
    private final double maxDistanceFromTarget;
    private final List<BlockPos> targetBlocks = new ArrayList<BlockPos>();
    private BlockState blockState = null;
    private Vec3 lastPosition = null;
    private int lastPositionTickstamp = 0;

    public DigToTargetGoal(AlienEntity mob) {
        this(mob, 16.0);
    }

    public DigToTargetGoal(AlienEntity mob, double maxDistanceFromTarget) {
        this.mob = mob;
        this.reachDistance = 4.0;
        this.maxDistanceFromTarget = maxDistanceFromTarget * maxDistanceFromTarget;
    }

    public boolean canUse() {
        if (!this.mob.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (this.mob.getTarget() == null) {
            return false;
        }
        return this.isStuck() && (this.mob.distanceToSqr((Entity)this.mob.getTarget()) > 2.0 || !this.mob.hasLineOfSight((Entity)this.mob.getTarget())) && this.mob.distanceToSqr((Entity)this.mob.getTarget()) < this.maxDistanceFromTarget;
    }

    public boolean canContinueToUse() {
        if (this.targetBlocks.isEmpty()) {
            return false;
        }
        LivingEntity target = this.mob.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        if (this.mob.isVehicle()) {
            return false;
        }
        return this.targetBlocks.getFirst().distSqr((Vec3i)this.mob.blockPosition()) < this.reachDistance * this.reachDistance && !this.mob.level().getBlockState(this.targetBlocks.getFirst()).isAir();
    }

    public void start() {
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return;
        }
        this.gatherTargetBlocks();
        if (!this.targetBlocks.isEmpty()) {
            this.initBlockBreak();
            this.mob.setAggressive(true);
        }
    }

    public void stop() {
        if (!this.targetBlocks.isEmpty()) {
            this.targetBlocks.clear();
        }
        this.blockState = null;
        this.lastPosition = null;
        this.mob.setAggressive(false);
    }

    public void tick() {
        float damage;
        if (this.targetBlocks.isEmpty()) {
            return;
        }
        LivingEntity target = this.mob.getTarget();
        BlockPos pos = this.targetBlocks.getFirst();
        this.mob.getLookControl().setLookAt((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        AttributeInstance attackAttribute = this.mob.getAttribute(Attributes.ATTACK_DAMAGE);
        float f = damage = attackAttribute == null ? 10.0f : (float)attackAttribute.getValue() * 2.0f;
        if (this.mob.tickCount % 4 == 0 && this.mob.level().getBlockState(pos).is(GigTags.WEAK_BLOCKS)) {
            this.mob.animationSelector.select(this.mob);
            BlockBreakProgressManager.damage(this.mob.level(), pos, damage);
            SoundType soundType = this.blockState.getSoundType();
            this.mob.level().playSound(null, pos, soundType.getHitSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 8.0f, soundType.getPitch() * 0.5f);
        } else if (this.mob.tickCount % 20 == 0) {
            this.mob.animationSelector.select(this.mob);
            Entity acidEntity = GigEntities.ACID.get().create(this.mob.level());
            acidEntity.setPos((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ());
            this.mob.level().addFreshEntity(acidEntity);
        }
        if (this.mob.level().getBlockState(pos).is(Blocks.AIR)) {
            this.targetBlocks.removeFirst();
            if (!this.targetBlocks.isEmpty()) {
                this.initBlockBreak();
            } else if (this.mob.distanceToSqr((Entity)target) > 2.0 && !this.mob.getSensing().hasLineOfSight((Entity)target)) {
                this.start();
            }
        }
    }

    private void initBlockBreak() {
        this.blockState = this.mob.level().getBlockState(this.targetBlocks.getFirst());
    }

    private void gatherTargetBlocks() {
        LivingEntity target = this.mob.getTarget();
        int mobWidth = Mth.ceil((float)this.mob.getBbWidth());
        int mobHeight = Mth.ceil((float)this.mob.getBbHeight());
        for (int i = 0; i < mobHeight; ++i) {
            for (int j = -mobWidth / 2; j <= mobWidth / 2; ++j) {
                for (int k = -mobWidth / 2; k <= mobWidth / 2; ++k) {
                    BlockState state;
                    double distance;
                    Vec3 from = this.mob.position().add((double)j, (double)i + 0.5, (double)k);
                    Vec3 to = target.getEyePosition(1.0f).add((double)j, (double)i, (double)k);
                    ClipContext clipContext = new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob);
                    BlockHitResult rayTraceResult = this.mob.level().clip(clipContext);
                    if (rayTraceResult.getType() == HitResult.Type.MISS || this.targetBlocks.contains(rayTraceResult.getBlockPos()) || rayTraceResult.getBlockPos().getY() > 320 || (distance = this.mob.distanceToSqr(rayTraceResult.getLocation())) > this.reachDistance * this.reachDistance || (state = this.mob.level().getBlockState(rayTraceResult.getBlockPos())).hasBlockEntity() || state.getDestroySpeed((BlockGetter)this.mob.level(), rayTraceResult.getBlockPos()) == -1.0f || state.getBlock().defaultDestroyTime() >= Blocks.IRON_BLOCK.defaultDestroyTime()) continue;
                    this.targetBlocks.add(rayTraceResult.getBlockPos());
                }
            }
        }
        Collections.reverse(this.targetBlocks);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean isStuck() {
        if (this.mob.getTarget() == null) {
            return false;
        }
        if (this.mob.distanceTo((Entity)this.mob.getTarget()) <= this.mob.getBbWidth()) {
            return false;
        }
        if (this.lastPosition == null || this.mob.distanceToSqr(this.lastPosition) > 2.25) {
            this.lastPosition = this.mob.position();
            this.lastPositionTickstamp = this.mob.tickCount;
        }
        return this.mob.getNavigation().isDone() || this.mob.tickCount - this.lastPositionTickstamp >= 60;
    }
}

