/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import java.util.EnumSet;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class SpitAcidGoal
extends Goal {
    protected final AlienEntity mob;
    private final double speedModifier;
    private Path path;
    private int ticksUntilNextAttack;
    int delayBeforeAttack;
    boolean triggeredAttackAnimation;
    private final int attackInterval = 80;
    protected final int delayTicksBeforeAttack;
    private long lastCanUseCheck;
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private int seeTime;
    private final float attackRadiusSqr;

    public SpitAcidGoal(AlienEntity mob, double speedModifier, int delayTicksBeforeAttack) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.delayTicksBeforeAttack = delayTicksBeforeAttack;
        this.attackRadiusSqr = 50.0f;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        long i = this.mob.level().getGameTime();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        LivingEntity target = this.mob.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        this.path = this.mob.getNavigation().createPath((Entity)target, 0);
        return this.path != null || !this.mob.isWithinMeleeAttackRange(target);
    }

    public boolean canContinueToUse() {
        LivingEntity target = this.mob.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        return this.mob.isWithinRestriction(target.blockPosition()) && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(target);
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.path, this.speedModifier);
        this.mob.setAggressive(true);
        this.ticksUntilNextAttack = 0;
        this.delayBeforeAttack = 0;
        this.triggeredAttackAnimation = false;
    }

    public void stop() {
        LivingEntity livingentity = this.mob.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
            this.mob.setTarget(null);
        }
        this.seeTime = 0;
        this.mob.setAggressive(false);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity target = this.mob.getTarget();
        if (target != null) {
            boolean flag1;
            double d0 = this.mob.distanceToSqr(target.getX(), target.getY(), target.getZ());
            boolean flag = this.mob.getSensing().hasLineOfSight((Entity)target);
            boolean bl = flag1 = this.seeTime > 0;
            if (flag != flag1) {
                this.seeTime = 0;
            }
            this.seeTime = flag ? ++this.seeTime : --this.seeTime;
            if (d0 <= (double)this.attackRadiusSqr && this.seeTime >= 20) {
                ++this.strafingTime;
            } else {
                this.mob.getNavigation().moveTo((Entity)target, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.mob.getRandom().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.mob.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                Entity entity = this.mob.getControlledVehicle();
                if (entity instanceof Mob) {
                    Mob mobVehicle = (Mob)entity;
                    mobVehicle.lookAt((Entity)target, 30.0f, 30.0f);
                }
                this.mob.lookAt((Entity)target, 30.0f, 30.0f);
            } else {
                this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            if (this.mob.isWithinMeleeAttackRange(target)) {
                this.checkAndPerformAttackMelee(target);
            } else {
                this.checkAndPerformAttack(target);
            }
        }
    }

    protected void checkAndPerformAttackMelee(LivingEntity target) {
        if (this.canPerformAttack(target) && this.mob.isWithinMeleeAttackRange(target)) {
            if (this.delayBeforeAttack > 0) {
                --this.delayBeforeAttack;
                if (this.delayBeforeAttack == this.delayTicksBeforeAttack && !this.triggeredAttackAnimation) {
                    this.mob.animationSelector.select(this.mob);
                    this.triggeredAttackAnimation = true;
                }
            } else {
                this.resetAttackCooldown();
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.mob.doHurtTarget((Entity)target);
                this.triggeredAttackAnimation = false;
            }
        } else {
            this.delayBeforeAttack = this.adjustedTickDelay(10);
            this.triggeredAttackAnimation = false;
        }
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        if (this.canPerformAttack(target)) {
            if (this.delayBeforeAttack > 0) {
                --this.delayBeforeAttack;
                if (this.delayBeforeAttack == this.delayTicksBeforeAttack && !this.triggeredAttackAnimation) {
                    this.mob.animationDispatcher.sendAcidSpit();
                    this.triggeredAttackAnimation = true;
                }
            } else {
                this.resetAttackCooldown();
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.mob.shootAcid(target, (LivingEntity)this.mob);
                this.triggeredAttackAnimation = false;
            }
        } else {
            this.delayBeforeAttack = this.adjustedTickDelay(10);
            this.triggeredAttackAnimation = false;
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(this.attackInterval);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(LivingEntity entity) {
        return this.isTimeToAttack() && !this.mob.isWithinMeleeAttackRange(entity) && this.mob.getSensing().hasLineOfSight((Entity)entity);
    }
}

