/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import java.util.EnumSet;
import java.util.Optional;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LungeAtFoodTargetGoal
extends Goal {
    private static final int DEFAULT_WIND_UP_TIME_IN_TICKS = 10;
    private static final float DEFAULT_DISTANCE_TARGET = -1.0f;
    private final Mob mob;
    private final int maxCooldown;
    private final float normalizedChance;
    private final double minLungeRange = 1.0;
    private final double maxLungeRange;
    private float distanceToTarget;
    private int windUpTimeInTicks;
    private int cooldown;
    @Nullable
    Runnable onLungeCallback;

    public LungeAtFoodTargetGoal(Mob mob, float normalizedChance, int cooldown, double maxLungeRange) {
        this.mob = mob;
        this.maxCooldown = cooldown;
        this.normalizedChance = normalizedChance;
        this.maxLungeRange = maxLungeRange;
        this.cooldown = 0;
        this.resetWindUpTimeInTicks();
        this.distanceToTarget = -1.0f;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        AlienEntity alienEntity;
        Mob mob = this.mob;
        if (mob instanceof AlienEntity && ((alienEntity = (AlienEntity)mob).isBirthed() || alienEntity.getGrowth() > 10.0f)) {
            return false;
        }
        this.cooldown = Math.max(this.cooldown - 1, 0);
        boolean canUse = !this.isOnCooldown() && this.mob.getRandom().nextFloat() < this.normalizedChance;
        Optional target = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(5.0)).stream().findFirst();
        return target.isPresent() && this.mob.onGround() && this.isInRange() && !this.canPathfind() && canUse && this.mob.getSensing().hasLineOfSight((Entity)target.get());
    }

    public boolean canContinueToUse() {
        AlienEntity alienEntity;
        Mob mob = this.mob;
        if (mob instanceof AlienEntity && ((alienEntity = (AlienEntity)mob).isBirthed() || alienEntity.getGrowth() > 10.0f)) {
            return false;
        }
        Optional target = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(5.0)).stream().findFirst();
        return !this.canPathfind() && target.isPresent() && this.mob.onGround() && this.mob.getSensing().hasLineOfSight((Entity)target.get());
    }

    public void start() {
        super.start();
        Optional target = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(5.0)).stream().findFirst();
        if (target != null) {
            this.mob.getLookControl().setLookAt((Entity)target.get(), 180.0f, 180.0f);
        }
    }

    public void tick() {
        Optional target = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(5.0)).stream().findFirst();
        if (target.isEmpty()) {
            return;
        }
        this.mob.getLookControl().setLookAt((Entity)target.get(), 180.0f, 180.0f);
        float currentDistanceToTarget = this.mob.distanceTo((Entity)target.get());
        if (this.distanceToTarget == -1.0f) {
            this.distanceToTarget = currentDistanceToTarget;
        }
        if (this.mob.getLastHurtByMobTimestamp() > 0 && this.mob.tickCount - this.mob.getLastHurtByMobTimestamp() < 20 || currentDistanceToTarget > this.distanceToTarget) {
            this.windUpTimeInTicks = 0;
        }
        if (this.windUpTimeInTicks > 0) {
            --this.windUpTimeInTicks;
            this.mob.getNavigation().stop();
            return;
        }
        this.distanceToTarget = currentDistanceToTarget;
        Vec3 deltaMovement = this.mob.getDeltaMovement().scale(0.2);
        Vec3 vectorDifference = ((ItemEntity)target.get()).getEyePosition().subtract(this.mob.getEyePosition());
        vectorDifference = vectorDifference.normalize().scale(0.2 * (double)this.distanceToTarget).add(deltaMovement.x, 0.0, deltaMovement.z);
        this.mob.setDeltaMovement(vectorDifference.x, Math.max(0.6, vectorDifference.y), vectorDifference.z);
        if (this.onLungeCallback != null) {
            this.onLungeCallback.run();
        }
        this.resetWindUpTimeInTicks();
        this.resetCooldown();
    }

    public void stop() {
        super.stop();
        this.resetCooldown();
        this.resetWindUpTimeInTicks();
        this.distanceToTarget = -1.0f;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public LungeAtFoodTargetGoal setOnLungeCallback(@Nullable Runnable onLungeCallback) {
        this.onLungeCallback = onLungeCallback;
        return this;
    }

    private boolean isOnCooldown() {
        return this.cooldown > 0;
    }

    private void resetCooldown() {
        this.cooldown = this.maxCooldown;
    }

    private void resetWindUpTimeInTicks() {
        this.windUpTimeInTicks = 10;
    }

    private boolean isInRange() {
        Optional target = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(5.0)).stream().findFirst();
        if (target.isEmpty()) {
            return false;
        }
        double distanceToHost = this.mob.distanceToSqr((Entity)target.get());
        double minimumRangeSquared = 1.0;
        double maximumRangeSquared = this.maxLungeRange * this.maxLungeRange;
        return distanceToHost <= maximumRangeSquared && distanceToHost >= minimumRangeSquared;
    }

    private boolean canPathfind() {
        Optional target = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(5.0)).stream().findFirst();
        if (target.isEmpty()) {
            return false;
        }
        return !this.mob.getNavigation().moveTo((Entity)target.get(), 1.0);
    }
}

