/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class DelayedAttackGoal
extends MeleeAttackGoal {
    int delayBeforeAttack;
    boolean triggeredAttackAnimation;
    protected final int delayTicksBeforeAttack;

    public DelayedAttackGoal(AlienEntity mob, double speedModifier, int delayTicksBeforeAttack) {
        super((PathfinderMob)mob, speedModifier, true);
        this.delayTicksBeforeAttack = delayTicksBeforeAttack;
    }

    public boolean canUse() {
        if (this.mob.isVehicle()) {
            return false;
        }
        if (this.mob.getTarget() != null && this.mob.getTarget().getInBlockState().is(GigBlocks.NEST_RESIN_WEB_CROSS.get())) {
            return false;
        }
        return super.canUse();
    }

    public boolean canContinueToUse() {
        if (this.mob.isVehicle()) {
            return false;
        }
        if (this.mob.getTarget() != null && this.mob.getTarget().getInBlockState().is(GigBlocks.NEST_RESIN_WEB_CROSS.get())) {
            return false;
        }
        return super.canContinueToUse();
    }

    public void start() {
        super.start();
        this.delayBeforeAttack = 0;
        this.triggeredAttackAnimation = false;
    }

    public void checkAndPerformAttack(LivingEntity target) {
        PathfinderMob pathfinderMob;
        if (this.canPerformAttack(target) && (pathfinderMob = this.mob) instanceof AlienEntity) {
            AlienEntity mob = (AlienEntity)pathfinderMob;
            if (this.delayBeforeAttack > 0) {
                --this.delayBeforeAttack;
                if (this.delayBeforeAttack == this.delayTicksBeforeAttack && !this.triggeredAttackAnimation) {
                    mob.animationSelector.select(mob);
                    this.triggeredAttackAnimation = true;
                }
            } else {
                this.resetAttackCooldown();
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.mob.doHurtTarget((Entity)target);
                this.triggeredAttackAnimation = false;
            }
        } else {
            this.delayBeforeAttack = this.adjustedTickDelay(10);
            this.triggeredAttackAnimation = false;
        }
    }
}

