/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import java.util.EnumSet;
import java.util.List;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class ChargeAtTargetGoal
extends Goal {
    private final AlienEntity alienEntity;
    private Activity currentActivity = Activity.NONE;
    private int attackTime;
    private Vec3 attackVec;

    public ChargeAtTargetGoal(AlienEntity alienEntity) {
        this.alienEntity = alienEntity;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (--this.attackTime > 0 || !this.alienEntity.onGround() || this.alienEntity.isPassenger()) {
            return false;
        }
        LivingEntity target = this.alienEntity.getTarget();
        if (target != null) {
            double distanceSqr = this.alienEntity.distanceToSqr((Entity)target);
            return distanceSqr >= 3.0 && this.alienEntity.hasLineOfSight((Entity)target);
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.currentActivity != Activity.NONE;
    }

    public boolean isInterruptable() {
        return false;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void start() {
        this.alienEntity.getNavigation().stop();
        this.attackTime = 20;
        this.currentActivity = Activity.CHARGE_UP;
        this.alienEntity.swing(InteractionHand.OFF_HAND);
        this.alienEntity.setDeltaMovement(this.alienEntity.getDeltaMovement().add(0.0, 0.3, 0.0));
        this.alienEntity.playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), 1.0f, 1.0f / (this.alienEntity.getRandom().nextFloat() * 0.4f + 0.8f));
        this.alienEntity.getNavigation().stop();
    }

    public void stop() {
        this.attackTime = this.alienEntity.getRandom().nextInt(20, 80);
        this.cancelCharging();
    }

    public void tick() {
        --this.attackTime;
        switch (this.currentActivity.ordinal()) {
            case 1: {
                this.tickChargeUp();
                break;
            }
            case 2: {
                this.tickCharging();
                break;
            }
            case 3: {
                this.tickStunned();
                break;
            }
        }
    }

    private void tickChargeUp() {
        LivingEntity target = this.alienEntity.getTarget();
        if (target == null || !target.isAlive()) {
            this.currentActivity = Activity.NONE;
            return;
        }
        if (this.alienEntity.level().isClientSide()) {
            this.alienEntity.animationDispatcher.sendRun();
        }
        this.alienEntity.getLookControl().setLookAt((Entity)target, 100.0f, 100.0f);
        if (this.attackTime <= 0) {
            this.attackVec = new Vec3(target.getX() - this.alienEntity.getX(), 0.0, target.getZ() - this.alienEntity.getZ()).normalize();
            this.alienEntity.setSprinting(true);
            this.attackTime = 20;
            this.currentActivity = Activity.CHARGING;
        }
    }

    private void tickCharging() {
        boolean hit;
        LivingEntity target = this.alienEntity.getTarget();
        if (this.alienEntity.level().isClientSide()) {
            this.alienEntity.animationDispatcher.sendRun();
        }
        this.alienEntity.lookAt(EntityAnchorArgument.Anchor.FEET, this.alienEntity.position().add(this.attackVec));
        this.alienEntity.setDeltaMovement(this.attackVec.x * 2.0, this.alienEntity.getDeltaMovement().y, this.attackVec.z * 2.0);
        if (target != null) {
            List list = this.alienEntity.level().getEntities((Entity)this.alienEntity, this.alienEntity.getBoundingBox().inflate(0.2));
            hit = list.contains(target);
        } else {
            hit = false;
        }
        if (hit) {
            this.alienEntity.swing(InteractionHand.MAIN_HAND);
            this.alienEntity.setDeltaMovement(this.attackVec.x * -1.2, 0.4, this.attackVec.z * -1.2);
            target.setDeltaMovement(this.attackVec.x * 3.0, 0.5, this.attackVec.z * 3.0);
            this.alienEntity.doHurtTarget((Entity)target);
            this.currentActivity = Activity.NONE;
        } else if (this.alienEntity.horizontalCollision) {
            this.alienEntity.hurt(this.alienEntity.level().damageSources().flyIntoWall(), 5.0f);
            this.alienEntity.setDeltaMovement(this.attackVec.x * -0.5, 0.5, this.attackVec.z * -0.5);
            this.cancelCharging();
            this.attackTime = 60;
            this.currentActivity = Activity.STUNNED;
        } else if (this.attackTime <= 0 || this.alienEntity.isInWater() || this.alienEntity.isInLava()) {
            this.currentActivity = Activity.NONE;
        }
    }

    private void tickStunned() {
        if (this.attackTime <= 0) {
            this.currentActivity = Activity.NONE;
        }
    }

    private void cancelCharging() {
        this.alienEntity.setSprinting(false);
    }

    private static enum Activity {
        NONE,
        CHARGE_UP,
        CHARGING,
        STUNNED;

    }
}

