/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block.storage;

import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.block.entity.IdolStorageEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SittingIdolInvisBlock
extends Block {
    private static final VoxelShape OUTLINE_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SittingIdolInvisBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.DRIPSTONE_BLOCK).strength(5.0f, 8.0f).noOcclusion().noLootTable());
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (!level.isClientSide) {
            Vec3i radius = new Vec3i(2, 2, 2);
            for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)pos.subtract(radius), (BlockPos)pos.offset(radius))) {
                if (!level.getBlockState(testPos).is(GigBlocks.ALIEN_STORAGE_BLOCK_3.get())) continue;
                BlockEntity blockEntity = level.getBlockEntity(testPos);
                if (blockEntity instanceof IdolStorageEntity) {
                    IdolStorageEntity idolStorageEntity = (IdolStorageEntity)blockEntity;
                    player.openMenu((MenuProvider)idolStorageEntity);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @NotNull
    public BlockState playerWillDestroy(Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        if (world.isClientSide) {
            return state;
        }
        Vec3i radius = new Vec3i(2, 2, 2);
        for (BlockPos testPos : BlockPos.betweenClosed((BlockPos)pos.subtract(radius), (BlockPos)pos.offset(radius))) {
            BlockState testState = world.getBlockState(testPos);
            if (testState.is(GigBlocks.ALIEN_STORAGE_BLOCK_3.get())) {
                world.destroyBlock(testPos, true);
                Block.dropResources((BlockState)testState, (Level)world, (BlockPos)testPos);
                continue;
            }
            if (!testState.is((Block)this)) continue;
            world.setBlock(testPos, Blocks.AIR.defaultBlockState(), 3);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return OUTLINE_SHAPE;
    }
}

