/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block.entity;

import java.util.Objects;
import mods.cybercat.gigeresque.common.block.entity.StorageDispatcher;
import mods.cybercat.gigeresque.common.block.storage.StorageProperties;
import mods.cybercat.gigeresque.common.block.storage.StorageStates;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.jetbrains.annotations.NotNull;

public class JarStorageEntity
extends RandomizableContainerBlockEntity {
    public static final EnumProperty<StorageStates> CHEST_STATE = StorageProperties.STORAGE_STATE;
    protected final ContainerOpenersCounter stateManager = new ContainerOpenersCounter(){

        protected void onOpen(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
            if (JarStorageEntity.this.level != null) {
                JarStorageEntity.this.level.playSound(null, pos, SoundEvents.ITEM_FRAME_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }

        protected void onClose(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
            if (JarStorageEntity.this.level != null) {
                JarStorageEntity.this.level.playSound(null, pos, SoundEvents.ITEM_FRAME_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }

        protected void openerCountChanged(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, int oldViewerCount, int newViewerCount) {
            JarStorageEntity.this.onInvOpenOrClose(world, pos, state, oldViewerCount, newViewerCount);
        }

        protected boolean isOwnContainer(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof ChestMenu) {
                ChestMenu menu = (ChestMenu)abstractContainerMenu;
                return menu.getContainer() == JarStorageEntity.this;
            }
            return false;
        }
    };
    public StorageDispatcher animationDispatcher;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);

    public JarStorageEntity(BlockPos pos, BlockState state) {
        super(GigEntities.ALIEN_STORAGE_BLOCK_ENTITY_2.get(), pos, state);
        this.animationDispatcher = new StorageDispatcher((BlockEntity)this);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, JarStorageEntity blockEntity) {
        if (blockEntity.getLevel() != null && !blockEntity.isRemoved()) {
            blockEntity.stateManager.recheckOpeners(blockEntity.getLevel(), blockEntity.getBlockPos(), blockEntity.getBlockState());
            if (blockEntity.getLevel().isClientSide()) {
                if (blockEntity.getChestState() == StorageStates.CLOSING) {
                    blockEntity.animationDispatcher.sendClose();
                } else if (blockEntity.getChestState() == StorageStates.OPENED) {
                    blockEntity.animationDispatcher.sendOpen();
                }
            }
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public int getContainerSize() {
        return 18;
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> list) {
        this.items = list;
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"block.gigeresque.alien_storage_block2");
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int syncId, @NotNull Inventory inventory) {
        return new ChestMenu(MenuType.GENERIC_9x1, syncId, inventory, (Container)this, 1);
    }

    public void startOpen(@NotNull Player player) {
        if (!this.isRemoved() && !player.isSpectator()) {
            this.stateManager.incrementOpeners(player, Objects.requireNonNull(this.getLevel()), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(@NotNull Player player) {
        if (!this.isRemoved() && !player.isSpectator()) {
            this.stateManager.decrementOpeners(player, Objects.requireNonNull(this.getLevel()), this.getBlockPos(), this.getBlockState());
        }
    }

    public void tick() {
        if (!this.isRemoved()) {
            this.stateManager.recheckOpeners(Objects.requireNonNull(this.getLevel()), this.getBlockPos(), this.getBlockState());
        }
    }

    protected void onInvOpenOrClose(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
        world.blockEvent(pos, state.getBlock(), 1, newViewerCount);
        if (oldViewerCount != newViewerCount) {
            if (newViewerCount > 0) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue(CHEST_STATE, (Comparable)((Object)StorageStates.OPENED)));
            } else {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue(CHEST_STATE, (Comparable)((Object)StorageStates.CLOSING)));
            }
        }
    }

    public StorageStates getChestState() {
        return (StorageStates)((Object)this.getBlockState().getValue(CHEST_STATE));
    }
}

