/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block;

import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.block.AbstractNestBlock;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class NestResinWebFullBlock
extends AbstractNestBlock {
    private int standingTick = 0;

    public NestResinWebFullBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void entityInside(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof AlienEntity) {
            return;
        }
        if (Constants.isCreativeSpecPlayer.test(entity)) {
            return;
        }
        if (entity instanceof LivingEntity && GigEntityUtils.isTargetHostable((Entity)(livingEntity = (LivingEntity)entity)) && !livingEntity.hasEffect(GigStatusEffects.IMPREGNATION)) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.handleEggMorphingForPlayer(player, state, pos, entity, world);
            } else if (livingEntity instanceof Mob) {
                this.handleEggMorphingForMob(livingEntity, state, entity);
            }
        }
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext entitycollisioncontext;
        return context instanceof EntityCollisionContext && (entitycollisioncontext = (EntityCollisionContext)context).getEntity() instanceof AlienEntity ? Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0) : super.getCollisionShape(state, world, pos, context);
    }

    private void handleEggMorphingForPlayer(Player player, BlockState state, BlockPos pos, Entity sourceEntity, Level world) {
        if (sourceEntity instanceof AlienEntity) {
            return;
        }
        player.makeStuckInBlock(state, new Vec3(0.25, (double)0.05f, 0.25));
        if (!player.hasEffect(GigStatusEffects.EGGMORPHING)) {
            player.addEffect(new MobEffectInstance(GigStatusEffects.EGGMORPHING, (int)CommonMod.config.getEggmorphTickTimer(), 0), sourceEntity);
        }
        if (!world.isClientSide) {
            ++this.standingTick;
        }
        if (this.standingTick >= 100) {
            if (!world.getBlockState(pos.below()).is(GigBlocks.NEST_RESIN_WEB_CROSS.get())) {
                player.setPos(pos.getCenter().x, (double)pos.getY(), pos.getCenter().z);
            } else {
                player.setPos(pos.getCenter().x, (double)pos.below().getY(), pos.getCenter().z);
            }
            player.makeStuckInBlock(state, new Vec3(0.25, 0.0, 0.25));
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 100, true, false), sourceEntity);
            this.standingTick = 0;
        }
    }

    private void handleEggMorphingForMob(LivingEntity mob, BlockState state, Entity sourceEntity) {
        if (mob instanceof AlienEntity || sourceEntity instanceof AlienEntity) {
            return;
        }
        if (!mob.hasEffect(GigStatusEffects.EGGMORPHING)) {
            mob.addEffect(new MobEffectInstance(GigStatusEffects.EGGMORPHING, (int)CommonMod.config.getEggmorphTickTimer(), 0), sourceEntity);
        }
        mob.makeStuckInBlock(state, new Vec3(0.25, 0.0, 0.25));
        mob.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 100, true, false), sourceEntity);
        this.standingTick = 0;
    }
}

