/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block;

import java.util.ArrayList;
import java.util.List;
import mods.cybercat.gigeresque.common.block.AbstractNestBlock;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestResinBlock
extends AbstractNestBlock {
    public static final IntegerProperty LAYERS = BlockStateProperties.LAYERS;
    protected static final List<VoxelShape> ALIEN_LAYERS_TO_SHAPE = NestResinBlock.interpolateShapes(false);
    protected static final List<VoxelShape> LAYERS_TO_SHAPE = NestResinBlock.interpolateShapes(true);

    public NestResinBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf(1)));
    }

    private static List<VoxelShape> interpolateShapes(boolean divide) {
        ArrayList<VoxelShape> list = new ArrayList<VoxelShape>();
        list.add(Shapes.empty());
        for (int i = 0; i < 8; ++i) {
            list.add(NestResinBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(divide ? (double)i * 2.0 / 2.0 : (double)i * 2.0), (double)16.0));
        }
        return list;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return ALIEN_LAYERS_TO_SHAPE.get((Integer)state.getValue((Property)LAYERS));
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        EntityCollisionContext entitycollisioncontext;
        return context instanceof EntityCollisionContext && (entitycollisioncontext = (EntityCollisionContext)context).getEntity() instanceof AlienEntity ? Block.box((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0) : LAYERS_TO_SHAPE.get((Integer)state.getValue((Property)LAYERS));
    }

    @NotNull
    public VoxelShape getBlockSupportShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return LAYERS_TO_SHAPE.get((Integer)state.getValue((Property)LAYERS));
    }

    @NotNull
    public VoxelShape getVisualShape(BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return LAYERS_TO_SHAPE.get((Integer)state.getValue((Property)LAYERS));
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    public boolean canSurvive(@NotNull BlockState state, LevelReader world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos.below());
        boolean isIce = blockState.is(Blocks.ICE);
        boolean isPackedIce = blockState.is(Blocks.PACKED_ICE);
        boolean isBarrier = blockState.is(Blocks.BARRIER);
        boolean isHoney = blockState.is(Blocks.HONEY_BLOCK);
        boolean isSoulSand = blockState.is(Blocks.SOUL_SAND);
        if (!(isIce || isPackedIce || isBarrier)) {
            if (!isHoney && !isSoulSand) {
                return NestResinBlock.isFaceFull((VoxelShape)blockState.getCollisionShape((BlockGetter)world, pos.below()), (Direction)Direction.UP) || blockState.is((Block)this) && (Integer)blockState.getValue((Property)LAYERS) == 8;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        return !state.canSurvive((LevelReader)world, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        int layers = (Integer)state.getValue((Property)LAYERS);
        if (context.getItemInHand().is(this.asItem()) && layers < 8) {
            if (context.replacingClickedOnBlock()) {
                return context.getClickedFace() == Direction.UP;
            }
            return true;
        }
        return layers == 1;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = ctx.getLevel().getBlockState(ctx.getClickedPos());
        if (blockState.is((Block)this)) {
            return (BlockState)blockState.setValue((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, (Integer)blockState.getValue((Property)LAYERS) + 1)));
        }
        return super.getStateForPlacement(ctx);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LAYERS});
    }
}

