/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block;

import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.client.particle.GigParticles;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class GigRotatedPillarBlock
extends RotatedPillarBlock {
    public GigRotatedPillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.animateTick(state, level, pos, random);
        double offsetX = random.nextDouble() - 0.5;
        double offsetY = 1.1 + random.nextDouble() * 1.3;
        double offsetZ = random.nextDouble() - 0.5;
        if ((level.getBlockState(pos.above()).isAir() || level.getBlockState(pos.above()).is(GigTags.ALLOW_MIST_BLOCKS)) && pos.getY() <= -50 && Constants.particleCount < 1500) {
            level.addParticle((ParticleOptions)GigParticles.MIST.get(), (double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + 0.5 + offsetZ, 0.0, 0.002, 0.0);
        }
    }
}

