/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.client.entity.texture.EggmorphLayerTexture;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class EggmorphFeatureRenderer<T extends Entity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static int fovEggticker = 0;
    private static final HashMap<ResourceLocation, EggmorphLayerTexture> textureCache = new HashMap();

    public EggmorphFeatureRenderer(RenderLayerParent<T, M> context) {
        super(context);
    }

    public static <T extends Entity> void renderEggmorphedModel(EntityModel<T> renderedModel, ResourceLocation texture, PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        matrices.pushPose();
        renderedModel.prepareMobModel(entity, limbAngle, limbDistance, tickDelta);
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(EggmorphFeatureRenderer.getEggmorphLayerTexture((ResourceLocation)texture).renderLayer);
        renderedModel.setupAnim(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        renderedModel.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
        matrices.popPose();
    }

    public static EggmorphLayerTexture getEggmorphLayerTexture(ResourceLocation texture) {
        return textureCache.computeIfAbsent(texture, identifier -> new EggmorphLayerTexture(Minecraft.getInstance().getTextureManager(), Minecraft.getInstance().getResourceManager(), texture));
    }

    public void render(@NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, @NotNull T entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hasEffect(GigStatusEffects.EGGMORPHING)) {
            VertexConsumer vertexConsumer = vertexConsumers.getBuffer(EggmorphFeatureRenderer.getEggmorphLayerTexture((ResourceLocation)this.getTextureLocation(entity)).renderLayer);
            float progress = Math.max(0.0f, Math.min((float)(++fovEggticker) / CommonMod.config.getEggmorphTickTimer(), 1.0f));
            EggmorphFeatureRenderer.renderEggmorphedModel(this.getParentModel(), this.getTextureLocation((Entity)entity), matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, progress, headYaw, headPitch);
        }
    }
}

