/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.classic;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import mods.cybercat.gigeresque.client.entity.model.ClassicModelRenderer;
import mods.cybercat.gigeresque.client.entity.model.EntityModels;
import mods.cybercat.gigeresque.client.entity.texture.EntityTextures;
import mods.cybercat.gigeresque.common.entity.animators.classic.ClassicAlienAnimator;
import mods.cybercat.gigeresque.common.entity.helper.managers.animations.classic.ClassicAlienAnimManager;
import mods.cybercat.gigeresque.common.entity.impl.classic.ClassicAlienEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class AlienEntityRenderer
extends AzEntityRenderer<ClassicAlienEntity> {
    public AlienEntityRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder($ -> EntityModels.ALIEN, xeno -> {
            if (xeno.stasisManager.isStasis()) {
                return EntityTextures.ALIEN_STATIS;
            }
            return EntityTextures.ALIEN;
        }).setAnimatorProvider(ClassicAlienAnimator::new).setDeathMaxRotation(0.0f).build(), context);
        this.shadowRadius = 0.5f;
    }

    protected AzEntityRendererPipeline<ClassicAlienEntity> createPipeline(AzEntityRendererConfig<ClassicAlienEntity> config) {
        return new AzEntityRendererPipeline<ClassicAlienEntity>(this, config, (AzEntityRenderer)this){

            protected AzModelRenderer<ClassicAlienEntity> createModelRenderer(AzLayerRenderer<ClassicAlienEntity> layerRenderer) {
                return new ClassicModelRenderer(this, layerRenderer);
            }
        };
    }

    public void render(ClassicAlienEntity entity, float entityYaw, float partialTick, PoseStack stack, @NotNull MultiBufferSource bufferSource, int packedLightIn) {
        float scaleFactor = 0.8f + entity.getGrowth() / entity.getMaxGrowth() / 5.0f;
        if (scaleFactor < 1.0f) {
            stack.scale(scaleFactor, scaleFactor, scaleFactor);
        }
        ClassicAlienAnimManager.handleAnimations(entity);
        super.render((Entity)entity, entityYaw, partialTick, stack, bufferSource, packedLightIn);
    }
}

