/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRenderer;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.layer.AzBlockAndItemLayer;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.block.animators.SittingIdolAnimator;
import mods.cybercat.gigeresque.common.block.entity.IdolStorageEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SittingIdolRender<T extends IdolStorageEntity>
extends AzBlockEntityRenderer<T> {
    private static final ResourceLocation MODEL = Constants.modResource("geo/block/sittingidol/sittingidol.geo.json");
    private static final ResourceLocation TEXTURE = Constants.modResource("textures/block/sittingidol/sittingidol.png");

    public SittingIdolRender() {
        super(AzBlockEntityRendererConfig.builder((ResourceLocation)MODEL, (ResourceLocation)TEXTURE).setAnimatorProvider(SittingIdolAnimator::new).addRenderLayer((AzRenderLayer)new AzBlockAndItemLayer<T>(){

            public ItemStack itemStackForBone(AzBone bone, T animatable) {
                return bone.getName().equalsIgnoreCase("heldItem") ? new ItemStack((ItemLike)GigBlocks.BEACON_BLOCK.get().asItem()) : null;
            }

            protected ItemDisplayContext getTransformTypeForStack(AzBone bone, ItemStack stack, T animatable) {
                return ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            }

            protected void renderItemForBone(AzRendererPipelineContext<T> context, AzBone bone, ItemStack itemStack, T animatable) {
                float rotationAngle = (float)(System.currentTimeMillis() % 3600L) / 10.0f;
                context.poseStack().mulPose(Axis.XP.rotationDegrees(rotationAngle));
                context.poseStack().mulPose(Axis.YP.rotationDegrees(rotationAngle));
                context.poseStack().mulPose(Axis.ZP.rotationDegrees(rotationAngle));
                super.renderItemForBone(context, bone, itemStack, animatable);
            }
        }).build());
    }

    public void render(@NotNull T entity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource source, int packedLight, int packedOverlay) {
        poseStack.scale(0.95f, 0.95f, 0.95f);
        super.render(entity, partialTick, poseStack, source, packedLight, packedOverlay);
    }
}

