/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.integrations;

import cy.jdkdigital.generatorgalore.common.recipe.SolidFuelRecipe;
import cy.jdkdigital.generatorgalore.integrations.JeiPlugin;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class SolidFuelRecipeCategory
implements IRecipeCategory<SolidFuelRecipe> {
    private final IDrawable background;
    private final IDrawable icon;

    public SolidFuelRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"textures/gui/jei/solid_fuel_recipe.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 126, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"iron_generator"))));
    }

    @NotNull
    public RecipeType<SolidFuelRecipe> getRecipeType() {
        return JeiPlugin.SOLID_FUEL_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"generatorgalore.recipe.solid_fuel");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SolidFuelRecipe recipe, @NotNull IFocusGroup iFocusGroup) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 0, 41).addItemStacks(Arrays.asList(recipe.generator().getItems()))).setSlotName("generator");
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 18, 41).addItemStacks(recipe.fuels().stream().flatMap(ingredient -> Arrays.stream(ingredient.getItems())).toList())).setSlotName("fuels");
    }

    public void draw(@NotNull SolidFuelRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics poseStack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        poseStack.drawString(minecraft.font, "Rate: " + recipe.rate() + "FE/t", 37.0f, 14.0f, 0x404040, false);
        poseStack.drawString(minecraft.font, "Burntime: " + recipe.consumptionRate(), 37.0f, 32.0f, 0x404040, false);
        poseStack.drawString(minecraft.font, "Total: " + (int)(recipe.rate() * recipe.consumptionRate()) + "FE", 37.0f, 50.0f, 0x404040, false);
    }
}

