/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.integrations;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.generatorgalore.common.recipe.FluidFuelRecipe;
import cy.jdkdigital.generatorgalore.common.recipe.SolidFuelRecipe;
import cy.jdkdigital.generatorgalore.init.ModTags;
import cy.jdkdigital.generatorgalore.integrations.FluidFuelRecipeCategory;
import cy.jdkdigital.generatorgalore.integrations.SolidFuelRecipeCategory;
import cy.jdkdigital.generatorgalore.registry.GeneratorRegistry;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.util.RegistryUtil;
import mezz.jei.library.plugins.vanilla.cooking.fuel.FuelRecipeMaker;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation pluginId = ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)"generatorgalore");
    public static RecipeType<SolidFuelRecipe> SOLID_FUEL_RECIPE_TYPE = RecipeType.create((String)"generatorgalore", (String)"solid_fuels", SolidFuelRecipe.class);
    public static RecipeType<FluidFuelRecipe> FLUID_FUEL_RECIPE_TYPE = RecipeType.create((String)"generatorgalore", (String)"fluid_fuels", FluidFuelRecipe.class);

    @Nonnull
    public ResourceLocation getPluginUid() {
        return pluginId;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        GeneratorRegistry.generators.forEach((resourceLocation, generator) -> {
            if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)generator.getBlockSupplier().get()), new RecipeType[]{FLUID_FUEL_RECIPE_TYPE});
            } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.SOLID) && generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG) && generator.getFuelList() == null) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)generator.getBlockSupplier().get()), new RecipeType[]{SOLID_FUEL_RECIPE_TYPE});
            } else {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)generator.getBlockSupplier().get()), new RecipeType[]{SOLID_FUEL_RECIPE_TYPE});
            }
        });
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidFuelRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SolidFuelRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List vanillaFuelRecipes = FuelRecipeMaker.getFuelRecipes((IIngredientManager)registration.getIngredientManager());
        List<ItemStack> foodList = registration.getIngredientManager().getAllItemStacks().stream().filter(stack -> {
            FoodProperties foodProperties = stack.getItem().getFoodProperties(stack, null);
            return foodProperties != null;
        }).toList();
        List enchantmentList = RegistryUtil.getRegistry((ResourceKey)Registries.ENCHANTMENT).holders().map(enchantment -> {
            ArrayList books = new ArrayList();
            IntStream.range(0, ((Enchantment)enchantment.value()).getMaxLevel()).forEach(i -> books.add(EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance((Holder)enchantment, i + 1))));
            return books;
        }).flatMap(Collection::stream).toList();
        List<Item> basePotions = List.of(Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION);
        List potionList = BuiltInRegistries.POTION.holders().map(potion -> {
            ArrayList<ItemStack> potions = new ArrayList<ItemStack>();
            if (((Potion)potion.value()).getEffects().size() > 0) {
                for (Item input : basePotions) {
                    ItemStack result = new ItemStack((ItemLike)input);
                    result.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents((Holder)potion));
                    potions.add(result);
                }
            }
            return potions;
        }).flatMap(Collection::stream).toList();
        GeneratorRegistry.generators.forEach((resourceLocation, generator) -> {
            Ingredient genIngredient = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)generator.getBlockSupplier().get()});
            String idPrefix = BuiltInRegistries.BLOCK.getKey((Object)generator.getBlockSupplier().get()).getPath();
            AtomicInteger i = new AtomicInteger();
            if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
                Optional fluids;
                ArrayList<FluidFuelRecipe> fuelRecipes = new ArrayList<FluidFuelRecipe>();
                if (!generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG) && (fluids = BuiltInRegistries.FLUID.getTag(ModTags.getFluidTag(generator.getFuelTag()))).isPresent()) {
                    List<FluidStack> fluidStacks = ((HolderSet.Named)fluids.get()).stream().map(fluid -> new FluidStack(fluid, 10000)).toList();
                    fuelRecipes.add(new FluidFuelRecipe(fluidStacks, genIngredient, (float)generator.getGenerationRate(), (float)generator.getConsumptionRate()));
                }
                registration.addRecipes(FLUID_FUEL_RECIPE_TYPE, fuelRecipes);
            } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.SOLID) && generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG) && generator.getFuelList() == null) {
                ArrayList fuelRecipes = new ArrayList();
                vanillaFuelRecipes.forEach(fuelingRecipe -> fuelRecipes.add(new SolidFuelRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{(ItemStack)fuelingRecipe.getInputs().get(0)})), genIngredient, (float)generator.getGenerationRate(), (int)((double)fuelingRecipe.getBurnTime() * generator.getConsumptionRate()))));
                registration.addRecipes(SOLID_FUEL_RECIPE_TYPE, fuelRecipes);
            } else {
                ArrayList<SolidFuelRecipe> fuelRecipes = new ArrayList<SolidFuelRecipe>();
                if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.SOLID)) {
                    if (generator.getFuelList() != null) {
                        generator.getFuelList().forEach((itemId, fuel) -> fuelRecipes.add(new SolidFuelRecipe(List.of(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(itemId)})), genIngredient, fuel.rate(), fuel.burnTime())));
                    } else if (!generator.getFuelTag().equals((Object)GeneratorUtil.EMPTY_TAG)) {
                        fuelRecipes.add(new SolidFuelRecipe(List.of(Ingredient.of(ModTags.getItemTag(generator.getFuelTag()))), genIngredient, (float)generator.getGenerationRate(), (int)generator.getConsumptionRate()));
                    }
                } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FOOD)) {
                    foodList.forEach(stack -> {
                        Pair<Float, Integer> rate = GeneratorUtil.calculateFoodGenerationRate(generator, stack);
                        fuelRecipes.add(new SolidFuelRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{stack})), genIngredient, ((Float)rate.getFirst()).floatValue(), ((Integer)rate.getSecond()).intValue()));
                    });
                } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.ENCHANTMENT)) {
                    enchantmentList.forEach(stack -> {
                        Pair<Float, Integer> rate = GeneratorUtil.calculateEnchantmentGenerationRate(generator, stack);
                        fuelRecipes.add(new SolidFuelRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{stack})), genIngredient, ((Float)rate.getFirst()).floatValue(), ((Integer)rate.getSecond()).intValue()));
                    });
                } else if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.POTION)) {
                    potionList.forEach(stack -> {
                        Pair<Float, Integer> rate = GeneratorUtil.calculatePotionGenerationRate((Level)Minecraft.getInstance().level, generator, stack);
                        fuelRecipes.add(new SolidFuelRecipe(List.of(Ingredient.of((ItemStack[])new ItemStack[]{stack})), genIngredient, ((Float)rate.getFirst()).floatValue(), ((Integer)rate.getSecond()).intValue()));
                    });
                }
                registration.addRecipes(SOLID_FUEL_RECIPE_TYPE, fuelRecipes);
            }
        });
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
    }
}

