/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.common.block.entity;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.generatorgalore.Config;
import cy.jdkdigital.generatorgalore.cap.ControlledEnergyStorage;
import cy.jdkdigital.generatorgalore.common.block.Generator;
import cy.jdkdigital.generatorgalore.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.generatorgalore.common.container.GeneratorMenu;
import cy.jdkdigital.generatorgalore.common.container.ManualItemHandler;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorBlockEntity
extends CapabilityBlockEntity {
    private int tickCounter = 0;
    public int litTime;
    public int litDuration;
    public double remainder = 0.0;
    public int fluidId = 0;
    public final GeneratorObject generator;
    private final int modifier;
    public final ControlledEnergyStorage energyHandler;
    public final ManualItemHandler inventoryHandler;
    public final FluidTank fluidInventory;
    private List<IEnergyStorage> recipients = new ArrayList<IEnergyStorage>();
    private boolean hasLoaded = false;

    public GeneratorBlockEntity(final GeneratorObject generator, BlockPos blockPos, BlockState blockState) {
        super(generator.getBlockEntityType().get(), blockPos, blockState);
        int n;
        this.generator = generator;
        Block block = blockState.getBlock();
        if (block instanceof Generator) {
            Generator generatorBlock = (Generator)block;
            n = generatorBlock.getModifier();
        } else {
            n = 1;
        }
        this.modifier = n;
        this.energyHandler = new ControlledEnergyStorage(generator.getBufferCapacity() * this.modifier);
        this.inventoryHandler = new ManualItemHandler(2){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 1) {
                    return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
                }
                return generator.isValidFuelItem(stack);
            }

            protected void onContentsChanged(int slot) {
                GeneratorBlockEntity.this.setChanged();
            }
        };
        this.fluidInventory = new FluidTank(10000){

            public boolean isFluidValid(FluidStack stack) {
                return generator.isValidFuelFluid(stack) || super.isFluidValid(stack);
            }

            protected void onContentsChanged() {
                super.onContentsChanged();
                if (generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
                    GeneratorBlockEntity.this.fluidId = BuiltInRegistries.FLUID.getId((Object)this.getFluid().getFluid());
                    GeneratorBlockEntity.this.setChanged();
                }
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GeneratorBlockEntity blockEntity) {
        int tickRate = (Integer)Config.SERVER.tickRate.get();
        if (!blockEntity.hasLoaded || blockEntity.tickCounter % 111 == 0) {
            blockEntity.refreshConnectedTileEntityCache();
            blockEntity.hasLoaded = true;
        }
        if (++blockEntity.tickCounter % tickRate == 0) {
            double inputPowerAmount = blockEntity.getGenerationRate() * (double)tickRate;
            AtomicBoolean hasConsumedFuel = new AtomicBoolean(false);
            if (!blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
                if (blockEntity.isLit()) {
                    blockEntity.litTime = Math.max(0, blockEntity.litTime - tickRate);
                }
                ItemStack fuelStack = blockEntity.inventoryHandler.getStackInSlot(0);
                if (!blockEntity.isLit() && !fuelStack.isEmpty() && blockEntity.inventoryHandler.isItemValid(0, fuelStack) && blockEntity.energyHandler.getEnergyStored() < blockEntity.energyHandler.getMaxEnergyStored()) {
                    boolean shouldBurn;
                    Pair<Float, Integer> rate = blockEntity.generator.getGenerationRateForItem(blockEntity.level, fuelStack);
                    boolean bl = shouldBurn = blockEntity.energyHandler.getEnergyStored() < blockEntity.energyHandler.getMaxEnergyStored() / 2 || ((Float)rate.getFirst()).floatValue() * (float)((Integer)rate.getSecond()).intValue() <= (float)(blockEntity.energyHandler.getMaxEnergyStored() - blockEntity.energyHandler.getEnergyStored());
                    if (shouldBurn) {
                        blockEntity.generator.setGenerationRate(((Float)rate.getFirst()).floatValue());
                        blockEntity.litTime = (Integer)rate.getSecond();
                        if (blockEntity.litTime == 0) {
                            blockEntity.litTime = (int)blockEntity.generator.getConsumptionRate();
                        }
                        blockEntity.litDuration = blockEntity.litTime;
                        if (blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.ENCHANTMENT)) {
                            blockEntity.inventoryHandler.setStackInSlot(0, new ItemStack((ItemLike)(fuelStack.getItem() instanceof EnchantedBookItem ? Items.BOOK : fuelStack.getItem())));
                        } else if (!fuelStack.getCraftingRemainingItem().isEmpty() && fuelStack.getCount() == 1) {
                            blockEntity.inventoryHandler.setStackInSlot(0, fuelStack.getCraftingRemainingItem());
                        } else {
                            fuelStack.shrink(1);
                        }
                    }
                }
                if (blockEntity.isLit()) {
                    hasConsumedFuel.set(true);
                }
            } else if (blockEntity.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID) && (double)blockEntity.energyHandler.getEnergyStored() + inputPowerAmount <= (double)blockEntity.energyHandler.getMaxEnergyStored()) {
                FluidStack fluidStack = blockEntity.fluidInventory.getFluidInTank(0);
                Pair<Double, Double> rate = blockEntity.generator.getGenerationRateForFluid(fluidStack);
                double fluidConsumeAmount = (Double)rate.getSecond() * (double)tickRate;
                if ((double)blockEntity.fluidInventory.getFluidInTank(0).getAmount() >= fluidConsumeAmount) {
                    blockEntity.fluidInventory.drain((int)fluidConsumeAmount, IFluidHandler.FluidAction.EXECUTE);
                    blockEntity.generator.setGenerationRate((Double)rate.getFirst());
                    hasConsumedFuel.set(true);
                }
            }
            if (hasConsumedFuel.get()) {
                inputPowerAmount = blockEntity.getGenerationRate() * (double)tickRate;
                int addedPower = (int)(inputPowerAmount += blockEntity.remainder);
                blockEntity.remainder = inputPowerAmount - (double)addedPower;
                blockEntity.energyHandler.receiveEnergy(addedPower, false, true);
                blockEntity.setOn(true);
            } else {
                blockEntity.setOn(false);
            }
            blockEntity.sendOutPower((int)blockEntity.generator.getTransferRate() * tickRate * blockEntity.modifier);
            blockEntity.setChanged();
        }
    }

    public double getGenerationRate() {
        return this.generator.getGenerationRate() * (double)this.modifier;
    }

    public boolean isLit() {
        return this.litTime > 0;
    }

    private void setOn(boolean isOn) {
        if (this.level != null && !this.level.isClientSide) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(isOn)));
        }
    }

    private void sendOutPower(int amount) {
        AtomicInteger capacity;
        if (this.level != null && (capacity = new AtomicInteger(this.energyHandler.getEnergyStored())).get() > 0) {
            IEnergyStorage chargeItemHandler;
            ItemStack chargeItem;
            AtomicBoolean dirty = new AtomicBoolean(false);
            if (this.generator.hasChargeSlot() && !(chargeItem = this.inventoryHandler.getStackInSlot(1)).isEmpty() && (chargeItemHandler = (IEnergyStorage)chargeItem.getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
                int received = chargeItemHandler.receiveEnergy(Math.min(capacity.get(), amount), false);
                capacity.addAndGet(-received);
                this.energyHandler.extractEnergy(received, false);
                dirty.set(true);
            }
            for (IEnergyStorage handler : this.recipients) {
                boolean doContinue;
                boolean bl = doContinue = capacity.get() > 0;
                if (handler.canReceive() && doContinue) {
                    int received = handler.receiveEnergy(Math.min(capacity.get(), amount), false);
                    capacity.addAndGet(-received);
                    this.energyHandler.extractEnergy(received, false);
                    dirty.set(true);
                }
                if (doContinue) continue;
                break;
            }
            if (dirty.get()) {
                this.setChanged();
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new GeneratorMenu(id, inventory, this);
    }

    public void refreshConnectedTileEntityCache() {
        if (this.level instanceof ServerLevel) {
            Direction[] directions;
            ArrayList<IEnergyStorage> recipients = new ArrayList<IEnergyStorage>();
            for (Direction direction : directions = Direction.values()) {
                IEnergyStorage energyCap = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.worldPosition.relative(direction), (Object)direction);
                if (energyCap == null) continue;
                recipients.add(energyCap);
            }
            this.recipients = recipients;
        }
    }

    @NotNull
    public Component getName() {
        return Component.translatable((String)("block.generatorgalore." + this.generator.getId().getPath().toLowerCase(Locale.ENGLISH) + "_generator" + (String)(this.modifier > 1 ? "_" + this.modifier + "x" : "")));
    }

    @Override
    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.litTime = pTag.getInt("litTime");
        this.litDuration = pTag.getInt("litDuration");
        if (pTag.contains("generationRate")) {
            this.generator.setGenerationRate(pTag.getDouble("generationRate"));
        }
    }

    @Override
    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("litTime", this.litTime);
        pTag.putInt("litDuration", this.litDuration);
        if (this.generator.getGenerationRate() != this.generator.getOriginalGenerationRate()) {
            pTag.putDouble("generationRate", this.generator.getGenerationRate());
        }
    }

    @Override
    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inv", (Tag)this.inventoryHandler.serializeNBT(pRegistries));
        tag.put("energy", this.energyHandler.serializeNBT(pRegistries));
        CompoundTag nbt = new CompoundTag();
        this.fluidInventory.writeToNBT(pRegistries, nbt);
        tag.put("item", (Tag)nbt);
    }

    @Override
    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (tag.contains("inv")) {
            this.inventoryHandler.deserializeNBT(pRegistries, tag.getCompound("inv"));
        }
        if (tag.contains("energy")) {
            this.energyHandler.deserializeNBT(pRegistries, tag.get("energy"));
        }
        if (tag.contains("item")) {
            this.fluidInventory.readFromNBT(pRegistries, tag.getCompound("item"));
        }
        if (this.generator.getFuelType().equals((Object)GeneratorUtil.FuelType.FLUID)) {
            Fluid fluid = this.fluidInventory.getFluidInTank(0).getFluid();
            this.fluidId = BuiltInRegistries.FLUID.getId((Object)fluid);
        }
    }
}

