/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.effects.WitheredStrike;

import com.gametechbc.gametechbcsspellbooks.init.GSSounds;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class WitheredStrikeEffect
extends MobEffect {
    private static final Random RANDOM = new Random();

    public WitheredStrikeEffect() {
        super(MobEffectCategory.BENEFICIAL, 0);
        this.addAttributeModifier(Attributes.ATTACK_DAMAGE, ResourceLocation.parse((String)"buff"), 0.06, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        super.applyEffectTick(entity, amplifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public void onAttack(LivingEntity attacker, LivingEntity target, int amplifier) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if ((double)RANDOM.nextFloat() < 0.5) {
                if (!this.isAlly(player, target)) {
                    target.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, amplifier));
                    this.spawnShockWaveParticle(target);
                    this.playSound(player, (SoundEvent)GSSounds.ABYSSAL_STRIKE_TRIGGER.get());
                }
                AABB areaOfEffect = player.getBoundingBox().inflate(8.0);
                player.level().getEntitiesOfClass(LivingEntity.class, areaOfEffect, entity -> entity != player && !this.isAlly(player, (LivingEntity)entity)).forEach(entity -> entity.addEffect(new MobEffectInstance(MobEffects.WITHER, 200, amplifier)));
            }
        }
    }

    private void spawnShockWaveParticle(LivingEntity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MagicManager.spawnParticles((Level)serverLevel, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.HOLY.get()).getTargetingColor(), 8.0f), (double)entity.getX(), (double)(entity.getY() + (double)0.165f), (double)entity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    private void playSound(Player player, SoundEvent soundEvent) {
        if (soundEvent != null && !player.level().isClientSide()) {
            player.playNotifySound(soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private boolean isAlly(Player player, LivingEntity entity) {
        if (entity instanceof Player) {
            return player.isAlliedTo((Entity)((Player)entity));
        }
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)entity;
            return tamable.isTame() && tamable.getOwner() == player;
        }
        return false;
    }
}

