/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.effects.FrozenSight;

import com.gametechbc.gametechbcsspellbooks.init.GSEffects;
import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="gametechbcs_spellbooks")
public class FrozenSightHandler {
    @SubscribeEvent
    public static void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            MobEffectInstance frozenSightEffect;
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.level().isClientSide && (frozenSightEffect = player.getEffect(GSEffects.FROZEN_SIGHT)) != null) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.literal((String)"Wait till it ends!").withStyle(ChatFormatting.RED), true);
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARMOR_STAND_HIT, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerCast(SpellPreCastEvent event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            MobEffectInstance frozenSightEffect;
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.level().isClientSide && (frozenSightEffect = player.getEffect(GSEffects.FROZEN_SIGHT)) != null) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.literal((String)"Wait till it ends!").withStyle(ChatFormatting.RED), true);
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARMOR_STAND_HIT, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        MobEffectInstance effectInstance = player.getEffect(GSEffects.FROZEN_SIGHT);
        if (effectInstance != null) {
            player.setOnGround(true);
            player.setJumping(false);
        }
    }
}

