/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.effects.Blackout;

import com.gametechbc.gametechbcsspellbooks.init.GSEffects;
import io.redspace.ironsspellbooks.api.events.ChangeManaEvent;
import io.redspace.ironsspellbooks.api.events.SpellPreCastEvent;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="gametechbcs_spellbooks")
public class BlackoutHandler {
    @SubscribeEvent
    public static void onPlayerCast(SpellPreCastEvent event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            MobEffectInstance blackoutEffect;
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.level().isClientSide && (blackoutEffect = player.getEffect(GSEffects.BLACKOUT)) != null) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.literal((String)"Blackout Active: Spells are suppressed!").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            MobEffectInstance blackoutEffect;
            ServerPlayer player = (ServerPlayer)entity;
            if (!player.level().isClientSide && (blackoutEffect = player.getEffect(GSEffects.BLACKOUT)) != null) {
                event.setCanceled(true);
                player.displayClientMessage((Component)Component.literal((String)"Blackout Active: Cannot use items!").withStyle(ChatFormatting.RED), true);
            }
        }
    }

    @SubscribeEvent
    public static void onManaRegen(ChangeManaEvent event) {
        if (event.getEntity().hasEffect(GSEffects.BLACKOUT)) {
            event.setCanceled(true);
        }
    }
}

