/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.item.FSItem;
import com.buuz135.functionalstorage.item.component.FunctionalUpgradeBehavior;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.util.FacingUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class UpgradeItem
extends FSItem {
    public static final int MAX_SLOT = 4;
    private final Type type;

    public static Direction getDirection(ItemStack stack) {
        Item item;
        if (stack.has(FSAttachments.DIRECTION) && ((item = stack.getItem()).equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get()))) {
            return (Direction)stack.get(FSAttachments.DIRECTION);
        }
        return Direction.NORTH;
    }

    public UpgradeItem(Item.Properties properties, Type type) {
        super(properties);
        this.type = type;
    }

    public UpgradeItem(FunctionalUpgradeBehavior behavior) {
        this(new Item.Properties().component(FSAttachments.FUNCTIONAL_BEHAVIOR, (Object)behavior), Type.UTILITY);
    }

    public void onCraftedBy(ItemStack p_41447_, Level p_41448_, Player p_41449_) {
        super.onCraftedBy(p_41447_, p_41448_, p_41449_);
        this.initNbt(p_41447_);
    }

    private ItemStack initNbt(ItemStack stack) {
        Item item = stack.getItem();
        if (item.equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get())) {
            stack.set(FSAttachments.DIRECTION, (Object)Direction.NORTH);
        }
        if (item.equals(FunctionalStorage.REDSTONE_UPGRADE.get())) {
            stack.set(FSAttachments.SLOT, (Object)0);
        }
        return stack;
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        Item item = stack.getItem();
        if ((item.equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get())) && !stack.has(FSAttachments.DIRECTION)) {
            stack.set(FSAttachments.DIRECTION, (Object)Direction.NORTH);
        }
        if (item.equals(FunctionalStorage.REDSTONE_UPGRADE.get()) && !stack.has(FSAttachments.SLOT)) {
            stack.set(FSAttachments.SLOT, (Object)0);
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean overrideOtherStackedOnMe(ItemStack first, ItemStack second, Slot p_150894_, ClickAction clickAction, Player p_150896_, SlotAccess p_150897_) {
        if (clickAction == ClickAction.SECONDARY && first.getCount() == 1) {
            Item item = first.getItem();
            if (item.equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get())) {
                Direction direction = UpgradeItem.getDirection(first);
                Direction next = Direction.values()[(Arrays.asList(Direction.values()).indexOf(direction) + 1) % Direction.values().length];
                first.set(FSAttachments.DIRECTION, (Object)next);
                p_150896_.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.5f, 1.0f);
                return true;
            }
            if (item.equals(FunctionalStorage.REDSTONE_UPGRADE.get())) {
                int slot = (Integer)first.getOrDefault(FSAttachments.SLOT, (Object)0);
                first.set(FSAttachments.SLOT, (Object)((slot + 1) % 4));
                p_150896_.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.5f, 1.0f);
                return true;
            }
        }
        return super.overrideOtherStackedOnMe(first, second, p_150894_, clickAction, p_150896_, p_150897_);
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        tooltip.add((Component)Component.translatable((String)"upgrade.type").withStyle(ChatFormatting.YELLOW).append((Component)Component.translatable((String)("upgrade.type." + this.getType().name().toLowerCase(Locale.ROOT))).withStyle(ChatFormatting.WHITE)));
        Item item = stack.getItem();
        if (UpgradeItem.isDirectionUpgrade(item) && stack.has(FSAttachments.DIRECTION)) {
            tooltip.add((Component)Component.translatable((String)"item.utility.direction").withStyle(ChatFormatting.YELLOW).append((Component)Component.translatable((String)("direction.titanium." + UpgradeItem.getDirection(stack).getName().toLowerCase(Locale.ROOT))).withStyle(ChatFormatting.WHITE)));
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"item.utility.direction.desc").withStyle(ChatFormatting.GRAY));
        }
        if (item.equals(FunctionalStorage.REDSTONE_UPGRADE.get()) && stack.has(FSAttachments.SLOT)) {
            tooltip.add((Component)Component.translatable((String)"item.utility.slot").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)((Integer)stack.get(FSAttachments.SLOT)).toString()).withStyle(ChatFormatting.WHITE)));
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"item.utility.direction.desc").withStyle(ChatFormatting.GRAY));
        }
    }

    public static boolean isDirectionUpgrade(Item item) {
        return item.equals(FunctionalStorage.PULLING_UPGRADE.get()) || item.equals(FunctionalStorage.PUSHING_UPGRADE.get()) || item.equals(FunctionalStorage.COLLECTOR_UPGRADE.get());
    }

    @Nullable
    public Component getDescription(ItemStack stack, ControllableDrawerTile<?> tile) {
        String type;
        Direction dir = (Direction)tile.getBlockState().getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        String string = type = tile instanceof FluidDrawerTile ? "fluid" : "item";
        if (this == FunctionalStorage.PUSHING_UPGRADE.get()) {
            return Component.translatable((String)("drawer_upgrade.functionalstorage.push." + type), (Object[])new Object[]{UpgradeItem.getRelativeDirection(UpgradeItem.getDirection(stack), dir).withStyle(ChatFormatting.GOLD)});
        }
        if (this == FunctionalStorage.PULLING_UPGRADE.get()) {
            return Component.translatable((String)("drawer_upgrade.functionalstorage.pull." + type), (Object[])new Object[]{UpgradeItem.getRelativeDirection(UpgradeItem.getDirection(stack), dir).withStyle(ChatFormatting.GOLD)});
        }
        if (this == FunctionalStorage.COLLECTOR_UPGRADE.get()) {
            return Component.translatable((String)("drawer_upgrade.functionalstorage.collect." + type), (Object[])new Object[]{UpgradeItem.getRelativeDirection(UpgradeItem.getDirection(stack), dir).withStyle(ChatFormatting.GOLD)});
        }
        if (this == FunctionalStorage.VOID_UPGRADE.get()) {
            return Component.translatable((String)("drawer_upgrade.functionalstorage.void." + type));
        }
        if (this == FunctionalStorage.REDSTONE_UPGRADE.get()) {
            return Component.translatable((String)"drawer_upgrade.functionalstorage.redstone", (Object[])new Object[]{Component.literal((String)String.valueOf(stack.getOrDefault(FSAttachments.SLOT, (Object)0))).withStyle(ChatFormatting.RED)});
        }
        return null;
    }

    public static MutableComponent getRelativeDirection(Direction upgrade, Direction facing) {
        return Component.translatable((String)("tooltip.titanium.facing_handler." + FacingUtil.getFacingRelative((Direction)upgrade, (Direction)facing).name().toLowerCase())).withStyle(ChatFormatting.WHITE);
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public static enum Type {
        STORAGE,
        UTILITY;

    }
}

