/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.compat.jade;

import com.buuz135.functionalstorage.block.EnderDrawerBlock;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.EnderDrawerTile;
import com.buuz135.functionalstorage.block.tile.FluidDrawerTile;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.fluid.BigFluidHandler;
import com.buuz135.functionalstorage.inventory.BigInventoryHandler;
import com.buuz135.functionalstorage.inventory.CompactingInventoryHandler;
import com.buuz135.functionalstorage.inventory.EnderInventoryHandler;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.buuz135.functionalstorage.item.component.SizeProvider;
import com.buuz135.functionalstorage.util.CompactingUtil;
import com.buuz135.functionalstorage.util.NumberUtils;
import com.buuz135.functionalstorage.util.Utils;
import com.buuz135.functionalstorage.world.EnderSavedData;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;
import snownee.jade.api.view.FluidView;

public enum DrawerComponentProvider implements IBlockComponentProvider
{
    INSTANCE;

    public static final ResourceLocation ITEM_STORAGE;
    public static final ResourceLocation ID;

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        iTooltip.remove(ITEM_STORAGE);
        iTooltip.remove(Utils.resourceLocation("minecraft:fluid_storage"));
        IElementHelper helper = IElementHelper.get();
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof ControllableDrawerTile) {
            EnderDrawerTile ender;
            ControllableDrawerTile controllable = (ControllableDrawerTile)blockEntity;
            BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
            if (blockEntity2 instanceof ItemControllableDrawerTile) {
                EnderDrawerTile ed;
                ItemControllableDrawerTile tile = (ItemControllableDrawerTile)blockEntity2;
                stacks = new ArrayList();
                if (tile instanceof EnderDrawerTile && (ed = (EnderDrawerTile)tile).getFrequency() != null) {
                    EnderInventoryHandler inv = EnderSavedData.getInstance((LevelAccessor)Minecraft.getInstance().level).getFrequency(ed.getFrequency());
                    for (int slot = 0; slot < inv.getSlots(); ++slot) {
                        BigInventoryHandler.BigStack stack2;
                        if (inv.isVoid() && slot + 1 == inv.getSlots() || (stack2 = inv.getStoredStacks().get(slot)).getStack().getItem() == Items.AIR) continue;
                        ((ArrayList)stacks).add(new Pair((Object)stack2.getStack().copyWithCount(stack2.getAmount()), (Object)inv.getSlotLimit(slot)));
                    }
                } else {
                    IItemHandler inv = tile.getStorage();
                    if (inv instanceof BigInventoryHandler) {
                        BigInventoryHandler bigInventoryHandler = (BigInventoryHandler)inv;
                        for (int slot = 0; slot < bigInventoryHandler.getStoredStacks().size(); ++slot) {
                            BigInventoryHandler.BigStack stack3 = bigInventoryHandler.getStoredStacks().get(slot);
                            if (stack3.getStack().getItem() == Items.AIR) continue;
                            ((ArrayList)stacks).add(new Pair((Object)stack3.getStack().copyWithCount(bigInventoryHandler.isCreative() ? Integer.MAX_VALUE : stack3.getAmount()), (Object)bigInventoryHandler.getSlotLimit(slot)));
                        }
                    } else {
                        IItemHandler slot = tile.getStorage();
                        if (slot instanceof CompactingInventoryHandler) {
                            CompactingInventoryHandler compacting = (CompactingInventoryHandler)slot;
                            List<CompactingUtil.Result> results = compacting.getResultList();
                            for (int i = 0; i < results.size(); ++i) {
                                CompactingUtil.Result result = results.get(i);
                                if (result.getResult().getItem() == Items.AIR) continue;
                                ((ArrayList)stacks).add(new Pair((Object)result.getResult().copyWithCount(compacting.isCreative() ? Integer.MAX_VALUE : compacting.getStackInSlot(i).getCount()), (Object)compacting.getSlotLimit(i)));
                            }
                        }
                    }
                }
                if (!((ArrayList)stacks).isEmpty()) {
                    ITooltip contentsBox = helper.tooltip();
                    iTooltip.add((IElement)helper.text((Component)Component.translatable((String)"drawer.block.contents")));
                    Iterator iterator = ((ArrayList)stacks).iterator();
                    while (iterator.hasNext()) {
                        boolean wasEmpty;
                        stack = (Pair)iterator.next();
                        boolean bl = wasEmpty = ((ItemStack)stack.getFirst()).getCount() == 0;
                        if (((ItemStack)stack.getFirst()).getCount() == 0) {
                            ((ItemStack)stack.getFirst()).setCount(1);
                        }
                        IElement icon = helper.item(((ItemStack)stack.getFirst()).copy(), 0.86f, "").size(new Vec2(15.4800005f, 15.4800005f)).translate(new Vec2(0.0f, -1.0f));
                        if (wasEmpty) {
                            ((ItemStack)stack.getFirst()).shrink(1);
                        }
                        contentsBox.add(icon);
                        contentsBox.append(helper.text((Component)Component.literal((String)"x ").append(NumberUtils.getFormatedBigNumber(((ItemStack)stack.getFirst()).getCount()) + " / " + NumberUtils.getFormatedBigNumber((Integer)stack.getSecond()))).translate(new Vec2(4.0f, 2.7400002f)));
                    }
                    iTooltip.add((IElement)helper.box(contentsBox, BoxStyle.getNestedBox()));
                }
            } else {
                FluidDrawerTile tile;
                stacks = blockAccessor.getBlockEntity();
                if (stacks instanceof FluidDrawerTile && !(tile = (FluidDrawerTile)((Object)stacks)).isInventoryEmpty()) {
                    stacks = new ArrayList();
                    for (int slot = 0; slot < tile.getFluidHandler().getTanks(); ++slot) {
                        BigFluidHandler.CustomFluidTank customFluidTank = tile.getFluidHandler().getTankList()[slot];
                        if (customFluidTank.getFluid().getFluid() == Fluids.EMPTY) continue;
                        ((ArrayList)stacks).add(new Pair((Object)customFluidTank.getFluid().copyWithAmount(customFluidTank.getFluidAmount()), (Object)tile.getFluidHandler().getTankCapacity(slot)));
                    }
                    if (!((ArrayList)stacks).isEmpty()) {
                        ITooltip contentsBox = helper.tooltip();
                        iTooltip.add((IElement)helper.text((Component)Component.translatable((String)"drawer.block.contents")));
                        Iterator iterator = ((ArrayList)stacks).iterator();
                        while (iterator.hasNext()) {
                            stack = (Pair)iterator.next();
                            FluidView view = new FluidView(helper.fluid(JadeFluidObject.of((Fluid)((FluidStack)stack.getFirst()).getFluid())));
                            ProgressStyle progressStyle = helper.progressStyle().overlay(view.overlay);
                            contentsBox.add(helper.progress((float)((FluidStack)stack.getFirst()).getAmount() / (float)((Integer)stack.getSecond()).intValue(), (Component)Component.empty().append(((FluidStack)stack.getFirst()).getHoverName()).append((Component)Component.literal((String)" x ").append(NumberUtils.getFormatedFluidBigNumber(((FluidStack)stack.getFirst()).getAmount()) + " / " + NumberUtils.getFormatedFluidBigNumber((Integer)stack.getSecond()))), progressStyle, BoxStyle.getNestedBox(), true));
                        }
                        iTooltip.add((IElement)helper.box(contentsBox, BoxStyle.getNestedBox()));
                    }
                }
            }
            if (controllable instanceof EnderDrawerTile && (ender = (EnderDrawerTile)controllable).getFrequency() != null) {
                List<ItemStack> freq = EnderDrawerBlock.getFrequencyDisplay(ender.getFrequency());
                ITooltip contentsBox = helper.tooltip();
                iTooltip.add((IElement)helper.text((Component)Component.translatable((String)"linkingtool.ender.frequency")));
                for (ItemStack itemStack : freq) {
                    contentsBox.append(helper.item(itemStack));
                }
                iTooltip.add((IElement)helper.box(contentsBox, BoxStyle.getNestedBox()));
            }
            if (Screen.hasShiftDown()) {
                InventoryComponent upInv = controllable.getUtilityUpgrades();
                for (int i = 0; i < upInv.getSlots(); ++i) {
                    ItemStack stack5 = upInv.getStackInSlot(i);
                    Item item = stack5.getItem();
                    if (!(item instanceof UpgradeItem)) continue;
                    UpgradeItem ui = (UpgradeItem)item;
                    iTooltip.add(ui.getDescription(stack5, controllable));
                }
                float mult = 1.0f;
                for (int i = 0; i < controllable.getStorageUpgrades().getSlots(); ++i) {
                    ItemStack stack6 = controllable.getStorageUpgrades().getStackInSlot(i);
                    SizeProvider sizeProvider = (SizeProvider)stack6.get(controllable.sizeUpgradeComponent);
                    if (sizeProvider == null) continue;
                    mult = sizeProvider.applyFactorModifier(mult);
                }
                if (mult > 1.0f) {
                    iTooltip.add((Component)Component.translatable((String)"drawer.block.multiplier", (Object[])new Object[]{Component.literal((String)("x" + (int)mult)).withStyle(ChatFormatting.GOLD)}));
                }
            }
        }
    }

    public int getDefaultPriority() {
        return 4999;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    static {
        ITEM_STORAGE = Utils.resourceLocation("minecraft:item_storage");
        ID = Utils.resourceLocation("functionalstorage", "drawer");
    }
}

