/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client.gui;

import com.buuz135.functionalstorage.util.NumberUtils;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class DrawerInfoGuiAddon
extends BasicScreenAddon {
    private final ResourceLocation gui;
    private final int slotAmount;
    private final Function<Integer, Pair<Integer, Integer>> slotPosition;
    private final Function<Integer, ItemStack> slotStack;
    private final Function<Integer, Integer> slotMaxAmount;

    public DrawerInfoGuiAddon(int posX, int posY, ResourceLocation gui, int slotAmount, Function<Integer, Pair<Integer, Integer>> slotPosition, Function<Integer, ItemStack> slotStack, Function<Integer, Integer> slotMaxAmount) {
        super(posX, posY);
        this.gui = gui;
        this.slotAmount = slotAmount;
        this.slotPosition = slotPosition;
        this.slotStack = slotStack;
        this.slotMaxAmount = slotMaxAmount;
    }

    public int getXSize() {
        return 0;
    }

    public int getYSize() {
        return 0;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        int size = 48;
        guiGraphics.blit(this.gui, guiX + this.getPosX(), guiY + this.getPosY(), 0.0f, 0.0f, size, size, size, size);
        for (int i = 0; i < this.slotAmount; ++i) {
            ItemStack itemStack = this.slotStack.apply(i);
            if (itemStack.isEmpty()) continue;
            int x = guiX + (Integer)this.slotPosition.apply(i).getLeft() + this.getPosX();
            int y = guiY + (Integer)this.slotPosition.apply(i).getRight() + this.getPosY();
            guiGraphics.renderItem(this.slotStack.apply(i), x, y);
            String amount = NumberUtils.getFormatedBigNumber(itemStack.getCount()) + "/" + NumberUtils.getFormatedBigNumber(this.slotMaxAmount.apply(i));
            float scale = 0.5f;
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            guiGraphics.pose().scale(scale, scale, scale);
            guiGraphics.drawString(Minecraft.getInstance().font, amount, (float)(x + 17 - Minecraft.getInstance().font.width(amount) / 2) * (1.0f / scale), (float)(y + 12) * (1.0f / scale), 0xFFFFFF, true);
            guiGraphics.pose().scale(1.0f / scale, 1.0f / scale, 1.0f / scale);
            guiGraphics.pose().translate(0.0f, 0.0f, -200.0f);
        }
    }

    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.slotAmount; ++i) {
            int x = (Integer)this.slotPosition.apply(i).getLeft() + this.getPosX() + guiX;
            int y = (Integer)this.slotPosition.apply(i).getRight() + this.getPosY() + guiY;
            if (mouseX <= x || mouseX >= x + 18 || mouseY <= y || mouseY >= y + 18) continue;
            x = (Integer)this.slotPosition.apply(i).getLeft() + this.getPosX();
            y = (Integer)this.slotPosition.apply(i).getRight() + this.getPosY();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            guiGraphics.fill(x - 1, y - 1, x + 17, y + 17, -2130706433);
            guiGraphics.pose().translate(0.0f, 0.0f, -200.0f);
            ArrayList<MutableComponent> componentList = new ArrayList<MutableComponent>();
            ItemStack over = this.slotStack.apply(i);
            if (over.isEmpty()) {
                componentList.add(Component.translatable((String)"gui.functionalstorage.item").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"gui.functionalstorage.empty").withStyle(ChatFormatting.WHITE)));
            } else {
                componentList.add(Component.translatable((String)"gui.functionalstorage.item").withStyle(ChatFormatting.GOLD).append((Component)over.getHoverName().copy().withStyle(ChatFormatting.WHITE)));
                String amount = NumberUtils.getFormatedBigNumber(over.getCount()) + "/" + NumberUtils.getFormatedBigNumber(this.slotMaxAmount.apply(i));
                componentList.add(Component.translatable((String)"gui.functionalstorage.amount").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)amount).withStyle(ChatFormatting.WHITE)));
            }
            componentList.add(Component.translatable((String)"gui.functionalstorage.slot").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)("" + i)).withStyle(ChatFormatting.WHITE)));
            guiGraphics.renderTooltip(Minecraft.getInstance().font, componentList, Optional.empty(), mouseX - guiX, mouseY - guiY);
        }
    }
}

