/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.DrawerProperties;
import com.buuz135.functionalstorage.block.tile.ItemControllableDrawerTile;
import com.buuz135.functionalstorage.client.gui.DrawerInfoGuiAddon;
import com.buuz135.functionalstorage.inventory.CompactingInventoryHandler;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.util.CompactingUtil;
import com.buuz135.functionalstorage.util.Utils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class SimpleCompactingDrawerTile
extends ItemControllableDrawerTile<SimpleCompactingDrawerTile> {
    @Save
    public CompactingInventoryHandler handler = new CompactingInventoryHandler(2){

        @Override
        public void onChange() {
            SimpleCompactingDrawerTile.this.markForUpdate();
        }

        @Override
        public int getMultiplier() {
            return SimpleCompactingDrawerTile.this.getStorageMultiplier();
        }

        @Override
        public boolean isVoid() {
            return SimpleCompactingDrawerTile.this.isVoid();
        }

        @Override
        public boolean isCreative() {
            return SimpleCompactingDrawerTile.this.isCreative();
        }

        @Override
        public boolean isLocked() {
            return SimpleCompactingDrawerTile.this.isLocked();
        }
    };
    private boolean hasCheckedRecipes = false;

    public SimpleCompactingDrawerTile(BasicTileBlock<SimpleCompactingDrawerTile> base, BlockEntityType<SimpleCompactingDrawerTile> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state, new DrawerProperties(8, FSAttachments.ITEM_STORAGE_MODIFIER));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new DrawerInfoGuiAddon(64, 16, Utils.resourceLocation("functionalstorage", "textures/block/simple_compacting_drawer_front.png"), 2, integer -> {
            if (integer == 0) {
                return Pair.of((Object)16, (Object)28);
            }
            if (integer == 1) {
                return Pair.of((Object)16, (Object)4);
            }
            return Pair.of((Object)16, (Object)4);
        }, integer -> this.getStorage().getStackInSlot(integer.intValue()), integer -> this.getStorage().getSlotLimit(integer.intValue())));
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, SimpleCompactingDrawerTile blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        if (!this.hasCheckedRecipes) {
            if (!this.handler.getParent().isEmpty()) {
                CompactingUtil compactingUtil = new CompactingUtil(this.level, 2);
                compactingUtil.setup(this.handler.getParent());
                this.handler.setup(compactingUtil);
            }
            this.hasCheckedRecipes = true;
        }
    }

    @Override
    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (stack.getItem().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.getItem().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (!this.handler.isSetup() && slot != -1) {
            stack = playerIn.getItemInHand(hand).copy();
            stack.setCount(1);
            CompactingUtil compactingUtil = new CompactingUtil(this.level, 2);
            compactingUtil.setup(stack);
            this.handler.setup(compactingUtil);
            for (int i = 0; i < this.handler.getResultList().size(); ++i) {
                if (!ItemStack.isSameItem((ItemStack)this.handler.getResultList().get(i).getResult(), (ItemStack)stack)) continue;
                slot = i;
                break;
            }
        }
        return super.onSlotActivated(playerIn, hand, facing, hitX, hitY, hitZ, slot);
    }

    @Override
    public int getStorageSlotAmount() {
        return 3;
    }

    @Override
    public IItemHandler getStorage() {
        return this.handler;
    }

    @Override
    protected boolean canChangeMultiplier(long newSizeMultiplier) {
        ItemStack stack = this.getStorage().getStackInSlot(1);
        if (stack.isEmpty()) {
            return true;
        }
        return (long)stack.getCount() <= Math.min(Integer.MAX_VALUE, (long)stack.getMaxStackSize() * newSizeMultiplier);
    }

    @NotNull
    public SimpleCompactingDrawerTile getSelf() {
        return this;
    }

    public CompactingInventoryHandler getHandler() {
        return this.handler;
    }
}

