/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.block.tile.DrawerProperties;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.item.component.SizeProvider;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.RayTraceUtils;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemControllableDrawerTile<T extends ItemControllableDrawerTile<T>>
extends ControllableDrawerTile<T> {
    private static HashMap<UUID, Long> INTERACTION_LOGGER = new HashMap();
    private int removeTicks = 0;

    public ItemControllableDrawerTile(BasicTileBlock<T> base, BlockEntityType<T> entityType, BlockPos pos, BlockState state, DrawerProperties props) {
        super(base, entityType, pos, state, props);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
    }

    @Override
    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        super.serverTick(level, pos, state, blockEntity);
        this.removeTicks = Math.max(this.removeTicks - 1, 0);
    }

    @Override
    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        ItemStack stack = playerIn.getItemInHand(hand);
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ItemInteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (slot != -1 && this.isServer()) {
            if (!stack.isEmpty() && this.getStorage().insertItem(slot, stack, true).getCount() != stack.getCount()) {
                playerIn.setItemInHand(hand, this.getStorage().insertItem(slot, stack, false));
                return InteractionResult.SUCCESS;
            }
            if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault(playerIn.getUUID(), System.currentTimeMillis()) < 300L) {
                for (ItemStack itemStack : playerIn.getInventory().items) {
                    if (itemStack.isEmpty() || this.getStorage().insertItem(slot, itemStack, true).getCount() == itemStack.getCount()) continue;
                    itemStack.setCount(this.getStorage().insertItem(slot, itemStack.copy(), false).getCount());
                }
            }
            INTERACTION_LOGGER.put(playerIn.getUUID(), System.currentTimeMillis());
        }
        if (super.onSlotActivated(playerIn, hand, facing, hitX, hitY, hitZ, slot) == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public abstract int getStorageSlotAmount();

    @Override
    public void onClicked(Player playerIn, int slot) {
        if (this.isServer() && slot != -1 && this.removeTicks == 0) {
            BlockHitResult blockResult;
            Direction facing;
            this.removeTicks = 3;
            HitResult rayTraceResult = RayTraceUtils.rayTraceSimple((Level)this.level, (LivingEntity)playerIn, (double)16.0, (float)0.0f);
            if (rayTraceResult.getType() == HitResult.Type.BLOCK && (facing = (blockResult = (BlockHitResult)rayTraceResult).getDirection()).equals((Object)this.getFacingDirection())) {
                ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)this.getStorage().extractItem(slot, playerIn.isShiftKeyDown() ? this.getStorage().getStackInSlot(slot).getMaxStackSize() : 1, false));
            }
        }
    }

    public abstract IItemHandler getStorage();

    @Override
    public InventoryComponent<ControllableDrawerTile<T>> getStorageUpgradesConstructor() {
        return new InventoryComponent<ControllableDrawerTile<T>>("storage_upgrades", 10, 70, this.getStorageSlotAmount()){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (ItemControllableDrawerTile.this.isStorageUpgradeLocked()) {
                    return ItemStack.EMPTY;
                }
                ItemStack stack = this.getStackInSlot(slot);
                if (stack.has(FSAttachments.ITEM_STORAGE_MODIFIER)) {
                    ItemStack[] replacement = new ItemStack[this.getSlots()];
                    replacement[slot] = ItemStack.EMPTY;
                    long newSize = SizeProvider.calculate((IItemHandler)this, FSAttachments.ITEM_STORAGE_MODIFIER, ItemControllableDrawerTile.this.baseSize, replacement);
                    if (!ItemControllableDrawerTile.this.canChangeMultiplier(newSize)) {
                        return ItemStack.EMPTY;
                    }
                }
                return super.extractItem(slot, amount, simulate);
            }
        }.setInputFilter((stack, integer) -> {
            if (this.isStorageUpgradeLocked()) {
                return false;
            }
            if (stack.is(FunctionalStorage.CREATIVE_UPGRADE)) {
                return true;
            }
            if (!stack.has(FSAttachments.ITEM_STORAGE_MODIFIER)) {
                return false;
            }
            ItemStack[] replacement = new ItemStack[this.getStorageUpgrades().getSlots()];
            replacement[integer.intValue()] = stack;
            long newSize = SizeProvider.calculate(this.getStorageUpgrades(), FSAttachments.ITEM_STORAGE_MODIFIER, this.baseSize, replacement);
            return this.canChangeMultiplier(newSize);
        }).setOnSlotChanged((stack, integer) -> this.setNeedsUpgradeCache(true)).setSlotLimit(1);
    }

    protected boolean canChangeMultiplier(long newSizeMultiplier) {
        for (int i = 0; i < this.getStorage().getSlots(); ++i) {
            ItemStack stored = this.getStorage().getStackInSlot(i);
            if (stored.isEmpty() || (long)stored.getCount() <= Math.min(Integer.MAX_VALUE, newSizeMultiplier * (long)stored.getMaxStackSize())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEverythingEmpty() {
        int i;
        for (i = 0; i < this.getStorage().getSlots(); ++i) {
            if (this.getStorage().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        for (i = 0; i < this.getStorageUpgrades().getSlots(); ++i) {
            if (this.getStorageUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        for (i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
            if (this.getUtilityUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isInventoryEmpty() {
        for (int i = 0; i < this.getStorage().getSlots(); ++i) {
            if (this.getStorage().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTitleColor() {
        return ChatFormatting.DARK_GRAY.getColor();
    }

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        return this.getStorage();
    }
}

