/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.tile.StorageControllerExtensionTile;
import com.buuz135.functionalstorage.block.tile.StorageControllerTile;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.util.TileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public abstract class StorageControllerExtensionBlock<T extends StorageControllerExtensionTile<T>>
extends RotatableBlock<T> {
    public StorageControllerExtensionBlock(String name, BlockBehaviour.Properties properties, Class<T> tileClass) {
        super(name, properties, tileClass);
        this.setItemGroup(FunctionalStorage.TAB);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)RotatableBlock.FACING_HORIZONTAL, (Comparable)Direction.NORTH)).setValue((Property)DrawerBlock.LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.createBlockStateDefinition(p_206840_1_);
        p_206840_1_.add(new Property[]{DrawerBlock.LOCKED});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        StorageControllerExtensionTile entity = TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, StorageControllerExtensionTile.class).orElse(null);
        if (entity != null) {
            InteractionResult result = entity.onSlotActivated(player, hand, ray.getDirection(), ray.getLocation().x, ray.getLocation().y, ray.getLocation().z);
            if (result == InteractionResult.SUCCESS) {
                return ItemInteractionResult.SUCCESS;
            }
            if (result.consumesAction()) {
                return ItemInteractionResult.CONSUME;
            }
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult ray) {
        StorageControllerExtensionTile entity = TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, StorageControllerExtensionTile.class).orElse(null);
        if (entity != null) {
            return entity.onSlotActivated(player, InteractionHand.MAIN_HAND, ray.getDirection(), ray.getLocation().x, ray.getLocation().y, ray.getLocation().z);
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)pos, StorageControllerExtensionTile.class).ifPresent(tile -> {
                if (tile.getControllerPos() != null) {
                    TileUtil.getTileEntity((BlockGetter)worldIn, (BlockPos)tile.getControllerPos(), StorageControllerTile.class).ifPresent(drawerControllerTile -> drawerControllerTile.addConnectedDrawers(LinkingToolItem.ActionMode.REMOVE, pos));
                }
            });
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }
}

