/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.Drawer;
import com.buuz135.functionalstorage.block.tile.DrawerTile;
import com.buuz135.functionalstorage.client.item.DrawerISTER;
import com.buuz135.functionalstorage.inventory.item.DrawerStackItemHandler;
import com.buuz135.functionalstorage.recipe.DrawerlessWoodIngredient;
import com.buuz135.functionalstorage.util.IWoodType;
import com.buuz135.functionalstorage.util.Utils;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.module.BlockWithTile;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class DrawerBlock
extends Drawer<DrawerTile> {
    public static final HashMap<FunctionalStorage.DrawerType, Multimap<Direction, VoxelShape>> CACHED_SHAPES;
    public static final BooleanProperty LOCKED;
    private final FunctionalStorage.DrawerType type;
    private final IWoodType woodType;

    public DrawerBlock(IWoodType woodType, FunctionalStorage.DrawerType type, BlockBehaviour.Properties properties) {
        super(woodType.getName() + "_" + type.getSlots(), properties, DrawerTile.class);
        this.woodType = woodType;
        this.type = type;
        this.setItemGroup(FunctionalStorage.TAB);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)RotatableBlock.FACING_HORIZONTAL, (Comparable)Direction.NORTH)).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntityType.BlockEntitySupplier<DrawerTile> getTileEntityFactory() {
        return (blockPos, state) -> new DrawerTile((BasicTileBlock<DrawerTile>)this, (BlockEntityType<DrawerTile>)((BlockEntityType)FunctionalStorage.DRAWER_TYPES.get((Object)this.type).stream().filter(registryObjectRegistryObjectPair -> registryObjectRegistryObjectPair.getBlock() == this).map(BlockWithTile::type).findFirst().get().get()), blockPos, state, this.type, this.woodType);
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return DrawerBlock.getShapes(state, source, pos, this.type);
    }

    private static List<VoxelShape> getShapes(BlockState state, BlockGetter source, BlockPos pos, FunctionalStorage.DrawerType type) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        CACHED_SHAPES.get((Object)type).get((Object)((Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL))).forEach(boxes::add);
        VoxelShape total = Shapes.block();
        boxes.add(total);
        return boxes;
    }

    @Override
    public Collection<VoxelShape> getHitShapes(BlockState state) {
        return CACHED_SHAPES.get((Object)this.type).get((Object)((Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL)));
    }

    public void registerRecipe(RecipeOutput consumer) {
        if (this.type == FunctionalStorage.DrawerType.X_1) {
            if (this.woodType.getName().equals("oak")) {
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).setName(Utils.resourceLocation("functionalstorage", "oak_drawer_alternate_x1")).pattern("PPP").pattern("PCP").pattern("PPP").define(Character.valueOf('P'), new DrawerlessWoodIngredient().toVanilla()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).save(consumer);
            } else {
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("PPP").pattern("PCP").pattern("PPP").define(Character.valueOf('P'), (ItemLike)this.woodType.getPlanks()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).save(consumer);
            }
        }
        if (this.type == FunctionalStorage.DrawerType.X_2) {
            if (this.woodType.getName().equals("oak")) {
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)2).setName(Utils.resourceLocation("functionalstorage", "oak_drawer_alternate_x2")).pattern("PCP").pattern("PPP").pattern("PCP").define(Character.valueOf('P'), new DrawerlessWoodIngredient().toVanilla()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).save(consumer);
            } else {
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)2).pattern("PCP").pattern("PPP").pattern("PCP").define(Character.valueOf('P'), (ItemLike)this.woodType.getPlanks()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).save(consumer);
            }
        }
        if (this.type == FunctionalStorage.DrawerType.X_4) {
            if (this.woodType.getName().equals("oak")) {
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)4).setName(Utils.resourceLocation("functionalstorage", "oak_drawer_alternate_x4")).pattern("CPC").pattern("PPP").pattern("CPC").define(Character.valueOf('P'), new DrawerlessWoodIngredient().toVanilla()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).save(consumer);
            } else {
                TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this, (int)4).pattern("CPC").pattern("PPP").pattern("CPC").define(Character.valueOf('P'), (ItemLike)this.woodType.getPlanks()).define(Character.valueOf('C'), Tags.Items.CHESTS_WOODEN).save(consumer);
            }
        }
    }

    public FunctionalStorage.DrawerType getType() {
        return this.type;
    }

    public IWoodType getWoodType() {
        return this.woodType;
    }

    static {
        AABB bounding;
        CACHED_SHAPES = new HashMap();
        LOCKED = BooleanProperty.create((String)"locked");
        CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_1, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)Direction.NORTH, (Object)Shapes.box((double)0.0625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.0625));
        CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_1, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)Direction.SOUTH, (Object)Shapes.box((double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.9375, (double)1.0));
        CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_1, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)Direction.WEST, (Object)Shapes.box((double)0.0, (double)0.0625, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375));
        CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_1, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)Direction.EAST, (Object)Shapes.box((double)0.9375, (double)0.0625, (double)0.0625, (double)1.0, (double)0.9375, (double)0.9375));
        for (Direction direction : CACHED_SHAPES.get((Object)FunctionalStorage.DrawerType.X_1).keySet()) {
            for (VoxelShape voxelShape : CACHED_SHAPES.get((Object)FunctionalStorage.DrawerType.X_1).get((Object)direction)) {
                bounding = (AABB)voxelShape.toAabbs().get(0);
                CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_2, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.box((double)bounding.minX, (double)bounding.minY, (double)bounding.minZ, (double)bounding.maxX, (double)0.4375, (double)bounding.maxZ));
                CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_2, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.box((double)bounding.minX, (double)0.5625, (double)bounding.minZ, (double)bounding.maxX, (double)bounding.maxY, (double)bounding.maxZ));
            }
        }
        for (Direction direction : CACHED_SHAPES.get((Object)FunctionalStorage.DrawerType.X_2).keySet()) {
            for (VoxelShape voxelShape : CACHED_SHAPES.get((Object)FunctionalStorage.DrawerType.X_2).get((Object)direction)) {
                bounding = (AABB)voxelShape.toAabbs().get(0);
                if (direction == Direction.SOUTH) {
                    CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.box((double)0.5625, (double)bounding.minY, (double)bounding.minZ, (double)bounding.maxX, (double)bounding.maxY, (double)bounding.maxZ));
                    CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.box((double)bounding.minX, (double)bounding.minY, (double)bounding.minZ, (double)0.4375, (double)bounding.maxY, (double)bounding.maxZ));
                    continue;
                }
                if (direction == Direction.NORTH) {
                    CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.box((double)bounding.minX, (double)bounding.minY, (double)bounding.minZ, (double)0.4375, (double)bounding.maxY, (double)bounding.maxZ));
                    CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.box((double)0.5625, (double)bounding.minY, (double)bounding.minZ, (double)bounding.maxX, (double)bounding.maxY, (double)bounding.maxZ));
                    continue;
                }
                if (direction == Direction.EAST) {
                    CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.box((double)bounding.minX, (double)bounding.minY, (double)bounding.minZ, (double)bounding.maxX, (double)bounding.maxY, (double)0.4375));
                    CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.box((double)bounding.minX, (double)bounding.minY, (double)0.5625, (double)bounding.maxX, (double)bounding.maxY, (double)bounding.maxZ));
                    continue;
                }
                CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.box((double)bounding.minX, (double)bounding.minY, (double)0.5625, (double)bounding.maxX, (double)bounding.maxY, (double)bounding.maxZ));
                CACHED_SHAPES.computeIfAbsent(FunctionalStorage.DrawerType.X_4, type1 -> MultimapBuilder.hashKeys().arrayListValues().build()).put((Object)direction, (Object)Shapes.box((double)bounding.minX, (double)bounding.minY, (double)bounding.minZ, (double)bounding.maxX, (double)bounding.maxY, (double)0.4375));
            }
        }
    }

    public static class DrawerItem
    extends BlockItem {
        private final DrawerBlock drawerBlock;

        public DrawerItem(DrawerBlock drawerBlock, Item.Properties properties, TitaniumTab tab) {
            super((Block)drawerBlock, properties);
            this.drawerBlock = drawerBlock;
        }

        @Nullable
        public IItemHandler initCapabilities(ItemStack stack) {
            return new DrawerStackItemHandler(stack, this.drawerBlock.getType());
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return switch (drawerBlock.getType()) {
                        case FunctionalStorage.DrawerType.X_2 -> DrawerISTER.SLOT_2;
                        case FunctionalStorage.DrawerType.X_4 -> DrawerISTER.SLOT_4;
                        default -> DrawerISTER.SLOT_1;
                    };
                }
            });
        }
    }
}

