/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.Drawer;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.SimpleCompactingDrawerBlock;
import com.buuz135.functionalstorage.block.tile.CompactingDrawerTile;
import com.buuz135.functionalstorage.client.item.CompactingDrawerISTER;
import com.buuz135.functionalstorage.inventory.item.CompactingStackItemHandler;
import com.buuz135.functionalstorage.recipe.TagWithoutComponentIngredient;
import com.buuz135.functionalstorage.util.StorageTags;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;

public class CompactingDrawerBlock
extends Drawer<CompactingDrawerTile> {
    public static Multimap<Direction, VoxelShape> CACHED_SHAPES = MultimapBuilder.hashKeys().arrayListValues().build();

    public CompactingDrawerBlock(String name, BlockBehaviour.Properties properties) {
        super(name, properties, CompactingDrawerTile.class);
        this.setItemGroup(FunctionalStorage.TAB);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)RotatableBlock.FACING_HORIZONTAL, (Comparable)Direction.NORTH)).setValue((Property)DrawerBlock.LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntityType.BlockEntitySupplier<CompactingDrawerTile> getTileEntityFactory() {
        return (blockPos, state) -> new CompactingDrawerTile((BasicTileBlock<CompactingDrawerTile>)this, (BlockEntityType<CompactingDrawerTile>)((BlockEntityType)FunctionalStorage.COMPACTING_DRAWER.type().get()), blockPos, state);
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return CompactingDrawerBlock.getShapes(state, source, pos);
    }

    private static List<VoxelShape> getShapes(BlockState state, BlockGetter source, BlockPos pos) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        CACHED_SHAPES.get((Object)((Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL))).forEach(boxes::add);
        VoxelShape total = Shapes.block();
        boxes.add(total);
        return boxes;
    }

    @Override
    public Collection<VoxelShape> getHitShapes(BlockState state) {
        return CACHED_SHAPES.get((Object)((Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL)));
    }

    public void registerRecipe(RecipeOutput consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("SSS").pattern("PDP").pattern("SIS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('P'), (ItemLike)Blocks.PISTON).define(Character.valueOf('D'), new TagWithoutComponentIngredient(StorageTags.DRAWER).toVanilla()).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).save(consumer);
    }

    static {
        CACHED_SHAPES.put((Object)Direction.NORTH, (Object)Shapes.box((double)0.0625, (double)0.0625, (double)0.0, (double)0.4375, (double)0.4375, (double)0.0625));
        CACHED_SHAPES.put((Object)Direction.NORTH, (Object)Shapes.box((double)0.5625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.4375, (double)0.0625));
        CACHED_SHAPES.put((Object)Direction.NORTH, (Object)Shapes.box((double)0.0625, (double)0.5625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.0625));
        CACHED_SHAPES.put((Object)Direction.SOUTH, (Object)Shapes.box((double)0.5625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.4375, (double)1.0));
        CACHED_SHAPES.put((Object)Direction.SOUTH, (Object)Shapes.box((double)0.0625, (double)0.0625, (double)0.9375, (double)0.4375, (double)0.4375, (double)1.0));
        CACHED_SHAPES.put((Object)Direction.SOUTH, (Object)Shapes.box((double)0.0625, (double)0.5625, (double)0.9375, (double)0.9375, (double)0.9375, (double)1.0));
        CACHED_SHAPES.put((Object)Direction.EAST, (Object)Shapes.box((double)0.9375, (double)0.0625, (double)0.0625, (double)1.0, (double)0.4375, (double)0.4375));
        CACHED_SHAPES.put((Object)Direction.EAST, (Object)Shapes.box((double)0.9375, (double)0.0625, (double)0.5625, (double)1.0, (double)0.4375, (double)0.9375));
        CACHED_SHAPES.put((Object)Direction.EAST, (Object)Shapes.box((double)0.9375, (double)0.5625, (double)0.0625, (double)1.0, (double)0.9375, (double)0.9375));
        CACHED_SHAPES.put((Object)Direction.WEST, (Object)Shapes.box((double)0.0, (double)0.0625, (double)0.5625, (double)0.0625, (double)0.4375, (double)0.9375));
        CACHED_SHAPES.put((Object)Direction.WEST, (Object)Shapes.box((double)0.0, (double)0.0625, (double)0.0625, (double)0.0625, (double)0.4375, (double)0.4375));
        CACHED_SHAPES.put((Object)Direction.WEST, (Object)Shapes.box((double)0.0, (double)0.5625, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375));
    }

    public static class CompactingDrawerItem
    extends BlockItem {
        private final int slots;

        public CompactingDrawerItem(Block block, Item.Properties properties, int slots) {
            super(block, properties);
            this.slots = slots;
        }

        public IItemHandler initCapabilities(ItemStack stack) {
            return new CompactingStackItemHandler(stack, this.slots);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return this.getBlock() instanceof SimpleCompactingDrawerBlock ? CompactingDrawerISTER.SIMPLE : CompactingDrawerISTER.NORMAL;
                }
            });
        }
    }
}

