/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.net.SyncConfigFromServerPacket;
import dev.ftb.mods.ftbultimine.net.SyncUltimineTimePacket;
import java.nio.file.Path;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record SyncConfigToServerPacket(SNBTCompoundTag config) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncConfigToServerPacket> TYPE = new CustomPacketPayload.Type(FTBUltimine.rl("sync_config_to_server_packet"));
    public static final StreamCodec<FriendlyByteBuf, SyncConfigToServerPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)SNBTCompoundTag.STREAM_CODEC, SyncConfigToServerPacket::config, SyncConfigToServerPacket::new);

    public CustomPacketPayload.Type<SyncConfigToServerPacket> type() {
        return TYPE;
    }

    public static void handle(SyncConfigToServerPacket message, NetworkManager.PacketContext context) {
        ServerPlayer sp;
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer && (sp = (ServerPlayer)player).hasPermissions(2)) {
            context.queue(() -> {
                MinecraftServer server = sp.getServer();
                FTBUltimine.LOGGER.info("Server config updated from client by player {}", (Object)sp.getName().getString());
                FTBUltimineServerConfig.CONFIG.read(message.config);
                FTBUltimineServerConfig.clearTagCache();
                Path file = server.getWorldPath(ConfigUtil.SERVER_CONFIG_DIR).resolve(FTBUltimineServerConfig.CONFIG.key + ".snbt");
                FTBUltimineServerConfig.CONFIG.save(file);
                for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                    if (!sp.getUUID().equals(player.getUUID())) {
                        NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncConfigFromServerPacket(message.config));
                    }
                    NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncUltimineTimePacket(FTBUltimineServerConfig.getUltimineCooldown(player), SyncUltimineTimePacket.TimeType.COOLDOWN));
                }
            });
        }
    }
}

