/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import com.google.common.collect.BiMap;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import dev.ftb.mods.ftbultimine.ItemCollection;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.mixin.AxeItemAccess;
import dev.ftb.mods.ftbultimine.mixin.ShovelItemAccess;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class RightClickHandlers {
    static int axeStripping(ServerPlayer player, InteractionHand hand, BlockPos clickPos, FTBUltiminePlayerData data) {
        HashSet<SoundEvent> sounds = new HashSet<SoundEvent>();
        Level level = player.level();
        ItemStack itemStack = player.getItemInHand(hand);
        AxeItemAccess axeItemAccess = (AxeItemAccess)itemStack.getItem();
        for (BlockPos pos : data.cachedPositions()) {
            BlockState state = player.level().getBlockState(pos);
            Optional<BlockState> stripping = axeItemAccess.invokeGetStripped(state);
            Optional scraping = WeatheringCopper.getPrevious((BlockState)state);
            Optional<BlockState> waxing = Optional.ofNullable((Block)((BiMap)HoneycombItem.WAX_OFF_BY_BLOCK.get()).get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state));
            Optional<Object> actual = Optional.empty();
            if (stripping.isPresent()) {
                sounds.add(SoundEvents.AXE_STRIP);
                actual = stripping;
            } else if (scraping.isPresent()) {
                sounds.add(SoundEvents.AXE_SCRAPE);
                level.levelEvent((Player)player, 3005, pos, 0);
                actual = scraping;
            } else if (waxing.isPresent()) {
                sounds.add(SoundEvents.AXE_WAX_OFF);
                level.levelEvent((Player)player, 3004, pos, 0);
                actual = waxing;
            }
            if (!actual.isPresent()) continue;
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(player, pos, itemStack);
            level.setBlock(pos, (BlockState)actual.get(), 11);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)((BlockState)actual.get())));
            boolean result = RightClickHandlers.hurtItemAndCheckIfBroken(player, hand);
            if (!result) continue;
            break;
        }
        sounds.forEach(sound -> level.playSound(null, clickPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f));
        return sounds.size();
    }

    static int shovelFlattening(ServerPlayer player, InteractionHand hand, BlockPos clickPos, FTBUltiminePlayerData data) {
        int didWork = 0;
        for (BlockPos pos : data.cachedPositions()) {
            if (!player.level().getBlockState(pos.above()).isAir()) continue;
            BlockState state = player.level().getBlockState(pos);
            BlockState newState = ShovelItemAccess.getFlattenables().get(state.getBlock());
            if (newState == null && state.is(FTBUltimine.FLATTENABLE_TAG)) {
                newState = Blocks.DIRT_PATH.defaultBlockState();
            }
            if (newState == null) continue;
            player.level().setBlock(pos, newState, 11);
            ++didWork;
            boolean result = RightClickHandlers.hurtItemAndCheckIfBroken(player, hand);
            player.level().gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)newState));
            if (!result && player.getFoodData().getFoodLevel() > 0) continue;
            break;
        }
        if (didWork > 0) {
            player.level().playSound((Player)player, clickPos, SoundEvents.SHOVEL_FLATTEN, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return didWork;
    }

    static boolean hurtItemAndCheckIfBroken(ServerPlayer player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        itemStack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
        return itemStack.isEmpty();
    }

    static int farmlandConversion(ServerPlayer player, InteractionHand hand, BlockPos clickPos, FTBUltiminePlayerData data) {
        int clicked = 0;
        for (BlockPos pos : data.cachedPositions()) {
            BlockState state;
            if (!player.level().getBlockState(pos.above()).isAir() || !(state = player.level().getBlockState(pos)).is(FTBUltimine.TILLABLE_TAG)) continue;
            player.level().setBlock(pos, Blocks.FARMLAND.defaultBlockState(), 11);
            player.level().gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)Blocks.FARMLAND.defaultBlockState()));
            ++clicked;
            if (player.isCreative()) continue;
            player.causeFoodExhaustion((float)(FTBUltimineServerConfig.getExhaustionPerBlock(player) * 0.005));
            if (!RightClickHandlers.hurtItemAndCheckIfBroken(player, hand) && !FTBUltimine.isTooExhausted(player)) continue;
            break;
        }
        if (clicked > 0) {
            player.level().playSound((Player)player, clickPos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return clicked;
    }

    static int cropHarvesting(ServerPlayer player, InteractionHand hand, BlockPos clickPos, Direction face, FTBUltiminePlayerData data) {
        int clicked = 0;
        ItemCollection itemCollection = new ItemCollection();
        for (BlockPos pos : data.cachedPositions()) {
            BlockState state = player.level().getBlockState(pos);
            if (!RightClickHandlers.isHarvestable(state)) continue;
            BlockEntity blockEntity = state.hasBlockEntity() ? player.level().getBlockEntity(pos) : null;
            List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)player.level()), (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)ItemStack.EMPTY);
            for (ItemStack stack : drops) {
                if (Block.byItem((Item)stack.getItem()) == state.getBlock() && RightClickHandlers.consumesItemToReplant(state)) {
                    stack.shrink(1);
                }
                itemCollection.add(stack);
            }
            RightClickHandlers.resetAge(player.level(), pos, state);
            ++clicked;
        }
        itemCollection.drop(player.level(), face == null ? clickPos : clickPos.relative(face));
        return clicked;
    }

    private static boolean consumesItemToReplant(BlockState state) {
        return state.getBlock() != Blocks.SWEET_BERRY_BUSH;
    }

    private static boolean isHarvestable(BlockState state) {
        CropBlock cropBlock;
        Block block = state.getBlock();
        return block instanceof CropBlock && (cropBlock = (CropBlock)block).isMaxAge(state) || state.getBlock() instanceof SweetBerryBushBlock && (Integer)state.getValue((Property)SweetBerryBushBlock.AGE) >= 3 || state.getBlock() instanceof CocoaBlock && (Integer)state.getValue((Property)CocoaBlock.AGE) >= 2;
    }

    private static void resetAge(Level level, BlockPos pos, BlockState currentState) {
        Block block = currentState.getBlock();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            level.setBlock(pos, cropBlock.getStateForAge(0), 3);
        } else if (currentState.getBlock() instanceof SweetBerryBushBlock) {
            level.setBlock(pos, (BlockState)currentState.setValue((Property)SweetBerryBushBlock.AGE, (Comparable)Integer.valueOf(1)), 3);
        } else if (currentState.getBlock() instanceof CocoaBlock) {
            level.setBlock(pos, (BlockState)currentState.setValue((Property)CocoaBlock.AGE, (Comparable)Integer.valueOf(0)), 3);
        }
    }
}

