/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.translation;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class TranslationTable {
    public static final StreamCodec<FriendlyByteBuf, TranslationTable> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.either((StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()))), t -> t.map, TranslationTable::new);
    private final Map<String, Either<String, List<String>>> map;
    private boolean saveNeeded;

    public TranslationTable() {
        this.map = new HashMap<String, Either<String, List<String>>>();
    }

    public static TranslationTable fromNBT(CompoundTag tag) {
        HashMap<String, Either<String, List<String>>> map = new HashMap<String, Either<String, List<String>>>();
        tag.getAllKeys().forEach(k -> {
            Tag selector0$temp = tag.get(k);
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringTag.class, ListTag.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    StringTag str = (StringTag)selector0$temp;
                    map.put((String)k, (Either<String, List<String>>)Either.left((Object)str.getAsString()));
                    break;
                }
                case 1: {
                    ListTag list = (ListTag)selector0$temp;
                    map.put((String)k, (Either<String, List<String>>)Either.right(list.stream().map(Tag::getAsString).toList()));
                    break;
                }
            }
        });
        return new TranslationTable(map);
    }

    private TranslationTable(Map<String, Either<String, List<String>>> map) {
        this.map = map;
    }

    boolean isSaveNeeded() {
        return this.saveNeeded;
    }

    void setSaveNeeded(boolean saveNeeded) {
        this.saveNeeded = saveNeeded;
    }

    public Optional<String> getStringTranslation(String key) {
        return Optional.ofNullable(this.map.get(key)).flatMap(e -> e.left());
    }

    public Optional<List<String>> getStringListTranslation(String key) {
        return Optional.ofNullable(this.map.get(key)).flatMap(e -> e.right());
    }

    public void put(String key, String message) {
        this.map.put(key, (Either<String, List<String>>)Either.left((Object)message));
        this.setSaveNeeded(true);
    }

    public void put(String key, List<String> message) {
        this.map.put(key, (Either<String, List<String>>)Either.right(message));
        this.setSaveNeeded(true);
    }

    public void remove(String key) {
        if (this.map.remove(key) != null) {
            this.setSaveNeeded(true);
        }
    }

    public CompoundTag saveToNBT() {
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> this.map.forEach((key, val) -> val.ifLeft(str -> {
            if (!str.isEmpty()) {
                tag.putString(key, str);
            }
        }).ifRight(list -> {
            if (!list.isEmpty()) {
                tag.put(key, (Tag)TranslationTable.listOfStr(list));
            }
        })));
    }

    static ListTag listOfStr(List<String> l) {
        return (ListTag)Util.make((Object)new ListTag(), t -> l.forEach(s -> t.add((Object)StringTag.valueOf((String)s))));
    }

    public int size() {
        return this.map.size();
    }

    public boolean contains(String key) {
        return this.map.containsKey(key);
    }
}

