/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.registry.registries.RegistrarManager;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class KillTask
extends Task {
    private static final ResourceLocation ZOMBIE = ResourceLocation.withDefaultNamespace((String)"zombie");
    private ResourceLocation entityTypeId = ZOMBIE;
    private long value = 100L;
    private String customName = "";
    private NameMap<ResourceLocation> entityNameMap = null;
    private static final Map<ResourceLocation, Icon> entityIcons = new HashMap<ResourceLocation, Icon>();

    public KillTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.KILL;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.writeData(nbt, provider);
        nbt.putString("entity", this.entityTypeId.toString());
        nbt.putLong("value", this.value);
        if (!this.customName.isEmpty()) {
            nbt.putString("custom_name", this.customName);
        }
    }

    @Override
    public void readData(CompoundTag nbt, HolderLookup.Provider provider) {
        super.readData(nbt, provider);
        this.entityTypeId = ResourceLocation.tryParse((String)nbt.getString("entity"));
        this.value = nbt.getLong("value");
        this.customName = nbt.getString("custom_name");
    }

    @Override
    public void writeNetData(RegistryFriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.writeUtf(this.entityTypeId.toString(), Short.MAX_VALUE);
        buffer.writeVarLong(this.value);
        buffer.writeUtf(this.customName);
    }

    @Override
    public void readNetData(RegistryFriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.entityTypeId = ResourceLocation.tryParse((String)buffer.readUtf(Short.MAX_VALUE));
        this.value = buffer.readVarInt();
        this.customName = buffer.readUtf();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        ArrayList ids = new ArrayList(BuiltInRegistries.ENTITY_TYPE.keySet());
        if (this.entityNameMap == null) {
            this.entityNameMap = NameMap.of((Object)ZOMBIE, ids).nameKey(id -> "entity." + id.toLanguageKey()).icon(KillTask::getIconForEntityType).create();
        }
        config.addEnum("entity", (Object)this.entityTypeId, v -> {
            this.entityTypeId = v;
        }, this.entityNameMap, (Object)ZOMBIE);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 100L, 1L, Long.MAX_VALUE);
        config.addString("custom_name", this.customName, v -> {
            this.customName = v;
        }, "");
    }

    private static Icon getIconForEntityType(ResourceLocation typeId) {
        return entityIcons.computeIfAbsent(typeId, k -> {
            ItemStack stack;
            Entity e;
            EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(typeId);
            if (entityType.equals(EntityType.PLAYER)) {
                return Icons.PLAYER;
            }
            SpawnEggItem item = SpawnEggItem.byId((EntityType)entityType);
            if (item == null && (e = entityType.create(FTBQuestsClient.getClientLevel())) != null && (stack = e.getPickResult()) != null) {
                item = stack.getItem();
            }
            return ItemIcon.getItemIcon((Item)(item != null ? item : Items.SPAWNER));
        });
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.entityNameMap = null;
        entityIcons.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        if (!this.customName.isEmpty()) {
            return Component.translatable((String)"ftbquests.task.ftbquests.kill.title_named", (Object[])new Object[]{this.formatMaxProgress(), Component.translatable((String)("entity." + this.entityTypeId.toLanguageKey())), Component.literal((String)this.customName)});
        }
        return Component.translatable((String)"ftbquests.task.ftbquests.kill.title", (Object[])new Object[]{this.formatMaxProgress(), Component.translatable((String)("entity." + this.entityTypeId.toLanguageKey()))});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        return KillTask.getIconForEntityType(this.entityTypeId);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    public void kill(TeamData teamData, LivingEntity e) {
        if (!teamData.isCompleted(this) && this.entityTypeId.equals((Object)RegistrarManager.getId((Object)e.getType(), (ResourceKey)Registries.ENTITY_TYPE)) && this.nameMatchOK(e)) {
            teamData.addProgress(this, 1L);
        }
    }

    private boolean nameMatchOK(LivingEntity e) {
        Player p;
        return this.customName.isEmpty() || (e instanceof Player ? (p = (Player)e).getGameProfile().getName().equals(this.customName) : e.getName().getString().equals(this.customName));
    }
}

